/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteApnsChannelResponse extends PinpointResponse implements
        ToCopyableBuilder<DeleteApnsChannelResponse.Builder, DeleteApnsChannelResponse> {
    private static final SdkField<APNSChannelResponse> APNS_CHANNEL_RESPONSE_FIELD = SdkField
            .<APNSChannelResponse> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteApnsChannelResponse::apnsChannelResponse))
            .setter(setter(Builder::apnsChannelResponse))
            .constructor(APNSChannelResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("APNSChannelResponse").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APNS_CHANNEL_RESPONSE_FIELD));

    private final APNSChannelResponse apnsChannelResponse;

    private DeleteApnsChannelResponse(BuilderImpl builder) {
        super(builder);
        this.apnsChannelResponse = builder.apnsChannelResponse;
    }

    /**
     * Returns the value of the APNSChannelResponse property for this object.
     * 
     * @return The value of the APNSChannelResponse property for this object.
     */
    public APNSChannelResponse apnsChannelResponse() {
        return apnsChannelResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apnsChannelResponse());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteApnsChannelResponse)) {
            return false;
        }
        DeleteApnsChannelResponse other = (DeleteApnsChannelResponse) obj;
        return Objects.equals(apnsChannelResponse(), other.apnsChannelResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteApnsChannelResponse").add("APNSChannelResponse", apnsChannelResponse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "APNSChannelResponse":
            return Optional.ofNullable(clazz.cast(apnsChannelResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteApnsChannelResponse, T> g) {
        return obj -> g.apply((DeleteApnsChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PinpointResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteApnsChannelResponse> {
        /**
         * Sets the value of the APNSChannelResponse property for this object.
         *
         * @param apnsChannelResponse
         *        The new value for the APNSChannelResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apnsChannelResponse(APNSChannelResponse apnsChannelResponse);

        /**
         * Sets the value of the APNSChannelResponse property for this object.
         *
         * This is a convenience that creates an instance of the {@link APNSChannelResponse.Builder} avoiding the need
         * to create one manually via {@link APNSChannelResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link APNSChannelResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #apnsChannelResponse(APNSChannelResponse)}.
         * 
         * @param apnsChannelResponse
         *        a consumer that will call methods on {@link APNSChannelResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apnsChannelResponse(APNSChannelResponse)
         */
        default Builder apnsChannelResponse(Consumer<APNSChannelResponse.Builder> apnsChannelResponse) {
            return apnsChannelResponse(APNSChannelResponse.builder().applyMutation(apnsChannelResponse).build());
        }
    }

    static final class BuilderImpl extends PinpointResponse.BuilderImpl implements Builder {
        private APNSChannelResponse apnsChannelResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteApnsChannelResponse model) {
            super(model);
            apnsChannelResponse(model.apnsChannelResponse);
        }

        public final APNSChannelResponse.Builder getApnsChannelResponse() {
            return apnsChannelResponse != null ? apnsChannelResponse.toBuilder() : null;
        }

        @Override
        public final Builder apnsChannelResponse(APNSChannelResponse apnsChannelResponse) {
            this.apnsChannelResponse = apnsChannelResponse;
            return this;
        }

        public final void setApnsChannelResponse(APNSChannelResponse.BuilderImpl apnsChannelResponse) {
            this.apnsChannelResponse = apnsChannelResponse != null ? apnsChannelResponse.build() : null;
        }

        @Override
        public DeleteApnsChannelResponse build() {
            return new DeleteApnsChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
