/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.SMSChannelResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SMSChannelResponseMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").isBinary(false).build();
    private static final MarshallingInfo<Boolean> HASCREDENTIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasCredential").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<Boolean> ISARCHIVED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsArchived").isBinary(false).build();
    private static final MarshallingInfo<String> LASTMODIFIEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedBy").isBinary(false).build();
    private static final MarshallingInfo<String> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<String> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").isBinary(false).build();
    private static final MarshallingInfo<String> SENDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SenderId").isBinary(false).build();
    private static final MarshallingInfo<String> SHORTCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShortCode").isBinary(false).build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Version").isBinary(false).build();
    private static final SMSChannelResponseMarshaller INSTANCE = new SMSChannelResponseMarshaller();

    private SMSChannelResponseMarshaller() {
    }

    public static SMSChannelResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SMSChannelResponse smsChannelResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)smsChannelResponse, (String)"smsChannelResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)smsChannelResponse.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.hasCredential(), HASCREDENTIAL_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.isArchived(), ISARCHIVED_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.lastModifiedBy(), LASTMODIFIEDBY_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.platform(), PLATFORM_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.senderId(), SENDERID_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.shortCode(), SHORTCODE_BINDING);
            protocolMarshaller.marshall((Object)smsChannelResponse.version(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

