/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EventStream;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventStreamMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApplicationId").isBinary(false).build();
    private static final MarshallingInfo<String> DESTINATIONSTREAMARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DestinationStreamArn").isBinary(false).build();
    private static final MarshallingInfo<String> EXTERNALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExternalId").isBinary(false).build();
    private static final MarshallingInfo<String> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<String> LASTUPDATEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdatedBy").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RoleArn").isBinary(false).build();
    private static final EventStreamMarshaller INSTANCE = new EventStreamMarshaller();

    private EventStreamMarshaller() {
    }

    public static EventStreamMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventStream eventStream, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventStream, (String)"eventStream");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)eventStream.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)eventStream.destinationStreamArn(), DESTINATIONSTREAMARN_BINDING);
            protocolMarshaller.marshall((Object)eventStream.externalId(), EXTERNALID_BINDING);
            protocolMarshaller.marshall((Object)eventStream.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)eventStream.lastUpdatedBy(), LASTUPDATEDBY_BINDING);
            protocolMarshaller.marshall((Object)eventStream.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

