/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SegmentDemographics;

@SdkInternalApi
public class SegmentDemographicsMarshaller {
    private static final MarshallingInfo<StructuredPojo> APPVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AppVersion").build();
    private static final MarshallingInfo<StructuredPojo> CHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Channel").build();
    private static final MarshallingInfo<StructuredPojo> DEVICETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeviceType").build();
    private static final MarshallingInfo<StructuredPojo> MAKE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Make").build();
    private static final MarshallingInfo<StructuredPojo> MODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Model").build();
    private static final MarshallingInfo<StructuredPojo> PLATFORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Platform").build();
    private static final SegmentDemographicsMarshaller INSTANCE = new SegmentDemographicsMarshaller();

    public static SegmentDemographicsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SegmentDemographics segmentDemographics, ProtocolMarshaller protocolMarshaller) {
        if (segmentDemographics == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)segmentDemographics.appVersion(), APPVERSION_BINDING);
            protocolMarshaller.marshall((Object)segmentDemographics.channel(), CHANNEL_BINDING);
            protocolMarshaller.marshall((Object)segmentDemographics.deviceType(), DEVICETYPE_BINDING);
            protocolMarshaller.marshall((Object)segmentDemographics.make(), MAKE_BINDING);
            protocolMarshaller.marshall((Object)segmentDemographics.model(), MODEL_BINDING);
            protocolMarshaller.marshall((Object)segmentDemographics.platform(), PLATFORM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

