/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.MessageResult;

@SdkInternalApi
public class MessageResultMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStatus").build();
    private static final MarshallingInfo<Integer> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusCode").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final MarshallingInfo<String> UPDATEDTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedToken").build();
    private static final MessageResultMarshaller INSTANCE = new MessageResultMarshaller();

    public static MessageResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MessageResult messageResult, ProtocolMarshaller protocolMarshaller) {
        if (messageResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)messageResult.deliveryStatusString(), DELIVERYSTATUS_BINDING);
            protocolMarshaller.marshall((Object)messageResult.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)messageResult.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageResult.updatedToken(), UPDATEDTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

