/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.APNSChannelRequest;

public class APNSChannelRequestUnmarshaller
implements Unmarshaller<APNSChannelRequest, JsonUnmarshallerContext> {
    private static final APNSChannelRequestUnmarshaller INSTANCE = new APNSChannelRequestUnmarshaller();

    public APNSChannelRequest unmarshall(JsonUnmarshallerContext context) throws Exception {
        APNSChannelRequest.Builder apnsChannelRequestBuilder = APNSChannelRequest.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BundleId", targetDepth)) {
                    context.nextToken();
                    apnsChannelRequestBuilder.bundleId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Certificate", targetDepth)) {
                    context.nextToken();
                    apnsChannelRequestBuilder.certificate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DefaultAuthenticationMethod", targetDepth)) {
                    context.nextToken();
                    apnsChannelRequestBuilder.defaultAuthenticationMethod((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    context.nextToken();
                    apnsChannelRequestBuilder.enabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("PrivateKey", targetDepth)) {
                    context.nextToken();
                    apnsChannelRequestBuilder.privateKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TeamId", targetDepth)) {
                    context.nextToken();
                    apnsChannelRequestBuilder.teamId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TokenKey", targetDepth)) {
                    context.nextToken();
                    apnsChannelRequestBuilder.tokenKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TokenKeyId", targetDepth)) {
                    context.nextToken();
                    apnsChannelRequestBuilder.tokenKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (APNSChannelRequest)apnsChannelRequestBuilder.build();
    }

    public static APNSChannelRequestUnmarshaller getInstance() {
        return INSTANCE;
    }
}

