/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.SendUsersMessageRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendUsersMessagesRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, SendUsersMessagesRequest> {
    private final String applicationId;
    private final SendUsersMessageRequest sendUsersMessageRequest;

    private SendUsersMessagesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.sendUsersMessageRequest = builder.sendUsersMessageRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public SendUsersMessageRequest sendUsersMessageRequest() {
        return this.sendUsersMessageRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sendUsersMessageRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessagesRequest)) {
            return false;
        }
        SendUsersMessagesRequest other = (SendUsersMessagesRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.sendUsersMessageRequest(), other.sendUsersMessageRequest());
    }

    public String toString() {
        return ToString.builder((String)"SendUsersMessagesRequest").add("ApplicationId", (Object)this.applicationId()).add("SendUsersMessageRequest", (Object)this.sendUsersMessageRequest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "SendUsersMessageRequest": {
                return Optional.of(clazz.cast(this.sendUsersMessageRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private SendUsersMessageRequest sendUsersMessageRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessagesRequest model) {
            this.applicationId(model.applicationId);
            this.sendUsersMessageRequest(model.sendUsersMessageRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final SendUsersMessageRequest.Builder getSendUsersMessageRequest() {
            return this.sendUsersMessageRequest != null ? this.sendUsersMessageRequest.toBuilder() : null;
        }

        @Override
        public final Builder sendUsersMessageRequest(SendUsersMessageRequest sendUsersMessageRequest) {
            this.sendUsersMessageRequest = sendUsersMessageRequest;
            return this;
        }

        public final void setSendUsersMessageRequest(SendUsersMessageRequest.BuilderImpl sendUsersMessageRequest) {
            this.sendUsersMessageRequest = sendUsersMessageRequest != null ? sendUsersMessageRequest.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SendUsersMessagesRequest build() {
            return new SendUsersMessagesRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, SendUsersMessagesRequest> {
        public Builder applicationId(String var1);

        public Builder sendUsersMessageRequest(SendUsersMessageRequest var1);

        default public Builder sendUsersMessageRequest(Consumer<SendUsersMessageRequest.Builder> sendUsersMessageRequest) {
            return this.sendUsersMessageRequest((SendUsersMessageRequest)((SendUsersMessageRequest.Builder)SendUsersMessageRequest.builder().apply(sendUsersMessageRequest)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

