/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSegmentRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, GetSegmentRequest> {
    private final String applicationId;
    private final String segmentId;

    private GetSegmentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.segmentId = builder.segmentId;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String segmentId() {
        return this.segmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentRequest)) {
            return false;
        }
        GetSegmentRequest other = (GetSegmentRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.segmentId(), other.segmentId());
    }

    public String toString() {
        return ToString.builder((String)"GetSegmentRequest").add("ApplicationId", (Object)this.applicationId()).add("SegmentId", (Object)this.segmentId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "SegmentId": {
                return Optional.of(clazz.cast(this.segmentId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String segmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentRequest model) {
            this.applicationId(model.applicationId);
            this.segmentId(model.segmentId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetSegmentRequest build() {
            return new GetSegmentRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, GetSegmentRequest> {
        public Builder applicationId(String var1);

        public Builder segmentId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

