/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteCampaignRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, DeleteCampaignRequest> {
    private final String applicationId;
    private final String campaignId;

    private DeleteCampaignRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String campaignId() {
        return this.campaignId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteCampaignRequest)) {
            return false;
        }
        DeleteCampaignRequest other = (DeleteCampaignRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.campaignId(), other.campaignId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteCampaignRequest").add("ApplicationId", (Object)this.applicationId()).add("CampaignId", (Object)this.campaignId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CampaignId": {
                return Optional.of(clazz.cast(this.campaignId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String campaignId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteCampaignRequest model) {
            this.applicationId(model.applicationId);
            this.campaignId(model.campaignId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteCampaignRequest build() {
            return new DeleteCampaignRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, DeleteCampaignRequest> {
        public Builder applicationId(String var1);

        public Builder campaignId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

