/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.pinpoint.model.EndpointBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateEndpointsBatchRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, UpdateEndpointsBatchRequest> {
    private final String applicationId;
    private final EndpointBatchRequest endpointBatchRequest;

    private UpdateEndpointsBatchRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.endpointBatchRequest = builder.endpointBatchRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public EndpointBatchRequest endpointBatchRequest() {
        return this.endpointBatchRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointBatchRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointsBatchRequest)) {
            return false;
        }
        UpdateEndpointsBatchRequest other = (UpdateEndpointsBatchRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.endpointBatchRequest(), other.endpointBatchRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.endpointBatchRequest() != null) {
            sb.append("EndpointBatchRequest: ").append(this.endpointBatchRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "EndpointBatchRequest": {
                return Optional.of(clazz.cast(this.endpointBatchRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private EndpointBatchRequest endpointBatchRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEndpointsBatchRequest model) {
            this.applicationId(model.applicationId);
            this.endpointBatchRequest(model.endpointBatchRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final EndpointBatchRequest.Builder getEndpointBatchRequest() {
            return this.endpointBatchRequest != null ? this.endpointBatchRequest.toBuilder() : null;
        }

        @Override
        public final Builder endpointBatchRequest(EndpointBatchRequest endpointBatchRequest) {
            this.endpointBatchRequest = endpointBatchRequest;
            return this;
        }

        public final void setEndpointBatchRequest(EndpointBatchRequest.BuilderImpl endpointBatchRequest) {
            this.endpointBatchRequest = endpointBatchRequest != null ? endpointBatchRequest.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateEndpointsBatchRequest build() {
            return new UpdateEndpointsBatchRequest(this);
        }
    }

    public static interface Builder
    extends PinpointRequest.Builder,
    CopyableBuilder<Builder, UpdateEndpointsBatchRequest> {
        public Builder applicationId(String var1);

        public Builder endpointBatchRequest(EndpointBatchRequest var1);

        default public Builder endpointBatchRequest(Consumer<EndpointBatchRequest.Builder> endpointBatchRequest) {
            return this.endpointBatchRequest((EndpointBatchRequest)((EndpointBatchRequest.Builder)EndpointBatchRequest.builder().apply(endpointBatchRequest)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

