/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.DirectMessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.EndpointSendConfiguration;
import software.amazon.awssdk.services.pinpoint.model.MapOfEndpointSendConfigurationCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.SendUsersMessageRequestMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendUsersMessageRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, SendUsersMessageRequest> {
    private final Map<String, String> context;
    private final DirectMessageConfiguration messageConfiguration;
    private final Map<String, EndpointSendConfiguration> users;

    private SendUsersMessageRequest(BuilderImpl builder) {
        this.context = builder.context;
        this.messageConfiguration = builder.messageConfiguration;
        this.users = builder.users;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public DirectMessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public Map<String, EndpointSendConfiguration> users() {
        return this.users;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.users());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendUsersMessageRequest)) {
            return false;
        }
        SendUsersMessageRequest other = (SendUsersMessageRequest)obj;
        return Objects.equals(this.context(), other.context()) && Objects.equals(this.messageConfiguration(), other.messageConfiguration()) && Objects.equals(this.users(), other.users());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.context() != null) {
            sb.append("Context: ").append(this.context()).append(",");
        }
        if (this.messageConfiguration() != null) {
            sb.append("MessageConfiguration: ").append(this.messageConfiguration()).append(",");
        }
        if (this.users() != null) {
            sb.append("Users: ").append(this.users()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Context": {
                return Optional.of(clazz.cast(this.context()));
            }
            case "MessageConfiguration": {
                return Optional.of(clazz.cast(this.messageConfiguration()));
            }
            case "Users": {
                return Optional.of(clazz.cast(this.users()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SendUsersMessageRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> context;
        private DirectMessageConfiguration messageConfiguration;
        private Map<String, EndpointSendConfiguration> users;

        private BuilderImpl() {
        }

        private BuilderImpl(SendUsersMessageRequest model) {
            this.context(model.context);
            this.messageConfiguration(model.messageConfiguration);
            this.users(model.users);
        }

        public final Map<String, String> getContext() {
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final DirectMessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(DirectMessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(DirectMessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final Map<String, EndpointSendConfiguration.Builder> getUsers() {
            return this.users != null ? CollectionUtils.mapValues(this.users, EndpointSendConfiguration::toBuilder) : null;
        }

        @Override
        public final Builder users(Map<String, EndpointSendConfiguration> users) {
            this.users = MapOfEndpointSendConfigurationCopier.copy(users);
            return this;
        }

        public final void setUsers(Map<String, EndpointSendConfiguration.BuilderImpl> users) {
            this.users = MapOfEndpointSendConfigurationCopier.copyFromBuilder(users);
        }

        public SendUsersMessageRequest build() {
            return new SendUsersMessageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendUsersMessageRequest> {
        public Builder context(Map<String, String> var1);

        public Builder messageConfiguration(DirectMessageConfiguration var1);

        default public Builder messageConfiguration(Consumer<DirectMessageConfiguration.Builder> messageConfiguration) {
            return this.messageConfiguration((DirectMessageConfiguration)((DirectMessageConfiguration.Builder)DirectMessageConfiguration.builder().apply(messageConfiguration)).build());
        }

        public Builder users(Map<String, EndpointSendConfiguration> var1);
    }
}

