/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageType;
import software.amazon.awssdk.services.pinpoint.transform.SMSMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SMSMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, SMSMessage> {
    private final String body;
    private final String messageType;
    private final String senderId;
    private final Map<String, List<String>> substitutions;

    private SMSMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.messageType = builder.messageType;
        this.senderId = builder.senderId;
        this.substitutions = builder.substitutions;
    }

    public String body() {
        return this.body;
    }

    public MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public String messageTypeString() {
        return this.messageType;
    }

    public String senderId() {
        return this.senderId;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.substitutions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSMessage)) {
            return false;
        }
        SMSMessage other = (SMSMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.messageTypeString(), other.messageTypeString()) && Objects.equals(this.senderId(), other.senderId()) && Objects.equals(this.substitutions(), other.substitutions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.messageTypeString() != null) {
            sb.append("MessageType: ").append(this.messageTypeString()).append(",");
        }
        if (this.senderId() != null) {
            sb.append("SenderId: ").append(this.senderId()).append(",");
        }
        if (this.substitutions() != null) {
            sb.append("Substitutions: ").append(this.substitutions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.of(clazz.cast(this.body()));
            }
            case "MessageType": {
                return Optional.of(clazz.cast(this.messageTypeString()));
            }
            case "SenderId": {
                return Optional.of(clazz.cast(this.senderId()));
            }
            case "Substitutions": {
                return Optional.of(clazz.cast(this.substitutions()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SMSMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String messageType;
        private String senderId;
        private Map<String, List<String>> substitutions;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSMessage model) {
            this.body(model.body);
            this.messageType(model.messageType);
            this.senderId(model.senderId);
            this.substitutions(model.substitutions);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType.toString());
            return this;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        public final String getSenderId() {
            return this.senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public SMSMessage build() {
            return new SMSMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SMSMessage> {
        public Builder body(String var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder senderId(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);
    }
}

