/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteCampaignRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateCampaignRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateCampaignRequest> {
    private final String applicationId;
    private final String campaignId;
    private final WriteCampaignRequest writeCampaignRequest;

    private UpdateCampaignRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.campaignId = builder.campaignId;
        this.writeCampaignRequest = builder.writeCampaignRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String campaignId() {
        return this.campaignId;
    }

    public WriteCampaignRequest writeCampaignRequest() {
        return this.writeCampaignRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeCampaignRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignRequest)) {
            return false;
        }
        UpdateCampaignRequest other = (UpdateCampaignRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.writeCampaignRequest(), other.writeCampaignRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.campaignId() != null) {
            sb.append("CampaignId: ").append(this.campaignId()).append(",");
        }
        if (this.writeCampaignRequest() != null) {
            sb.append("WriteCampaignRequest: ").append(this.writeCampaignRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CampaignId": {
                return Optional.of(clazz.cast(this.campaignId()));
            }
            case "WriteCampaignRequest": {
                return Optional.of(clazz.cast(this.writeCampaignRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String campaignId;
        private WriteCampaignRequest writeCampaignRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignRequest model) {
            this.applicationId(model.applicationId);
            this.campaignId(model.campaignId);
            this.writeCampaignRequest(model.writeCampaignRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        public final WriteCampaignRequest.Builder getWriteCampaignRequest() {
            return this.writeCampaignRequest != null ? this.writeCampaignRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeCampaignRequest(WriteCampaignRequest writeCampaignRequest) {
            this.writeCampaignRequest = writeCampaignRequest;
            return this;
        }

        public final void setWriteCampaignRequest(WriteCampaignRequest.BuilderImpl writeCampaignRequest) {
            this.writeCampaignRequest = writeCampaignRequest != null ? writeCampaignRequest.build() : null;
        }

        public UpdateCampaignRequest build() {
            return new UpdateCampaignRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateCampaignRequest> {
        public Builder applicationId(String var1);

        public Builder campaignId(String var1);

        public Builder writeCampaignRequest(WriteCampaignRequest var1);

        default public Builder writeCampaignRequest(Consumer<WriteCampaignRequest.Builder> writeCampaignRequest) {
            return this.writeCampaignRequest((WriteCampaignRequest)((WriteCampaignRequest.Builder)WriteCampaignRequest.builder().apply(writeCampaignRequest)).build());
        }
    }
}

