/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.MessageRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SendMessagesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SendMessagesRequest> {
    private final String applicationId;
    private final MessageRequest messageRequest;

    private SendMessagesRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.messageRequest = builder.messageRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public MessageRequest messageRequest() {
        return this.messageRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageRequest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessagesRequest)) {
            return false;
        }
        SendMessagesRequest other = (SendMessagesRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.messageRequest(), other.messageRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.messageRequest() != null) {
            sb.append("MessageRequest: ").append(this.messageRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "MessageRequest": {
                return Optional.of(clazz.cast(this.messageRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private MessageRequest messageRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessagesRequest model) {
            this.applicationId(model.applicationId);
            this.messageRequest(model.messageRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final MessageRequest.Builder getMessageRequest() {
            return this.messageRequest != null ? this.messageRequest.toBuilder() : null;
        }

        @Override
        public final Builder messageRequest(MessageRequest messageRequest) {
            this.messageRequest = messageRequest;
            return this;
        }

        public final void setMessageRequest(MessageRequest.BuilderImpl messageRequest) {
            this.messageRequest = messageRequest != null ? messageRequest.build() : null;
        }

        public SendMessagesRequest build() {
            return new SendMessagesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SendMessagesRequest> {
        public Builder applicationId(String var1);

        public Builder messageRequest(MessageRequest var1);

        default public Builder messageRequest(Consumer<MessageRequest.Builder> messageRequest) {
            return this.messageRequest((MessageRequest)((MessageRequest.Builder)MessageRequest.builder().apply(messageRequest)).build());
        }
    }
}

