/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Duration;
import software.amazon.awssdk.services.pinpoint.model.RecencyType;
import software.amazon.awssdk.services.pinpoint.transform.RecencyDimensionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RecencyDimension
implements StructuredPojo,
ToCopyableBuilder<Builder, RecencyDimension> {
    private final String duration;
    private final String recencyType;

    private RecencyDimension(BuilderImpl builder) {
        this.duration = builder.duration;
        this.recencyType = builder.recencyType;
    }

    public Duration duration() {
        return Duration.fromValue(this.duration);
    }

    public String durationString() {
        return this.duration;
    }

    public RecencyType recencyType() {
        return RecencyType.fromValue(this.recencyType);
    }

    public String recencyTypeString() {
        return this.recencyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.durationString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recencyTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecencyDimension)) {
            return false;
        }
        RecencyDimension other = (RecencyDimension)obj;
        return Objects.equals(this.durationString(), other.durationString()) && Objects.equals(this.recencyTypeString(), other.recencyTypeString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.durationString() != null) {
            sb.append("Duration: ").append(this.durationString()).append(",");
        }
        if (this.recencyTypeString() != null) {
            sb.append("RecencyType: ").append(this.recencyTypeString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Duration": {
                return Optional.of(clazz.cast(this.durationString()));
            }
            case "RecencyType": {
                return Optional.of(clazz.cast(this.recencyTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RecencyDimensionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String duration;
        private String recencyType;

        private BuilderImpl() {
        }

        private BuilderImpl(RecencyDimension model) {
            this.duration(model.duration);
            this.recencyType(model.recencyType);
        }

        public final String getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(String duration) {
            this.duration = duration;
            return this;
        }

        @Override
        public final Builder duration(Duration duration) {
            this.duration(duration.toString());
            return this;
        }

        public final void setDuration(String duration) {
            this.duration = duration;
        }

        public final String getRecencyType() {
            return this.recencyType;
        }

        @Override
        public final Builder recencyType(String recencyType) {
            this.recencyType = recencyType;
            return this;
        }

        @Override
        public final Builder recencyType(RecencyType recencyType) {
            this.recencyType(recencyType.toString());
            return this;
        }

        public final void setRecencyType(String recencyType) {
            this.recencyType = recencyType;
        }

        public RecencyDimension build() {
            return new RecencyDimension(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RecencyDimension> {
        public Builder duration(String var1);

        public Builder duration(Duration var1);

        public Builder recencyType(String var1);

        public Builder recencyType(RecencyType var1);
    }
}

