/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetSegmentVersionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetSegmentVersionsRequest> {
    private final String applicationId;
    private final String pageSize;
    private final String segmentId;
    private final String token;

    private GetSegmentVersionsRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.pageSize = builder.pageSize;
        this.segmentId = builder.segmentId;
        this.token = builder.token;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String pageSize() {
        return this.pageSize;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSegmentVersionsRequest)) {
            return false;
        }
        GetSegmentVersionsRequest other = (GetSegmentVersionsRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.segmentId(), other.segmentId()) && Objects.equals(this.token(), other.token());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.segmentId() != null) {
            sb.append("SegmentId: ").append(this.segmentId()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "SegmentId": {
                return Optional.of(clazz.cast(this.segmentId()));
            }
            case "Token": {
                return Optional.of(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String pageSize;
        private String segmentId;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSegmentVersionsRequest model) {
            this.applicationId(model.applicationId);
            this.pageSize(model.pageSize);
            this.segmentId(model.segmentId);
            this.token(model.token);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public GetSegmentVersionsRequest build() {
            return new GetSegmentVersionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetSegmentVersionsRequest> {
        public Builder applicationId(String var1);

        public Builder pageSize(String var1);

        public Builder segmentId(String var1);

        public Builder token(String var1);
    }
}

