/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAppsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetAppsRequest> {
    private final String pageSize;
    private final String token;

    private GetAppsRequest(BuilderImpl builder) {
        this.pageSize = builder.pageSize;
        this.token = builder.token;
    }

    public String pageSize() {
        return this.pageSize;
    }

    public String token() {
        return this.token;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.token());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppsRequest)) {
            return false;
        }
        GetAppsRequest other = (GetAppsRequest)((Object)obj);
        return Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.token(), other.token());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.token() != null) {
            sb.append("Token: ").append(this.token()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "Token": {
                return Optional.of(clazz.cast(this.token()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String pageSize;
        private String token;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppsRequest model) {
            this.pageSize(model.pageSize);
            this.token(model.token);
        }

        public final String getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(String pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public final String getToken() {
            return this.token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public GetAppsRequest build() {
            return new GetAppsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetAppsRequest> {
        public Builder pageSize(String var1);

        public Builder token(String var1);
    }
}

