/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAppRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetAppRequest> {
    private final String applicationId;

    private GetAppRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAppRequest)) {
            return false;
        }
        GetAppRequest other = (GetAppRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAppRequest model) {
            this.applicationId(model.applicationId);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public GetAppRequest build() {
            return new GetAppRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetAppRequest> {
        public Builder applicationId(String var1);
    }
}

