/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.EmailChannelResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EmailChannelResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, EmailChannelResponse> {
    private final String applicationId;
    private final String creationDate;
    private final Boolean enabled;
    private final String fromAddress;
    private final Boolean hasCredential;
    private final String id;
    private final String identity;
    private final Boolean isArchived;
    private final String lastModifiedBy;
    private final String lastModifiedDate;
    private final String platform;
    private final String roleArn;
    private final Integer version;

    private EmailChannelResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.enabled = builder.enabled;
        this.fromAddress = builder.fromAddress;
        this.hasCredential = builder.hasCredential;
        this.id = builder.id;
        this.identity = builder.identity;
        this.isArchived = builder.isArchived;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.platform = builder.platform;
        this.roleArn = builder.roleArn;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String fromAddress() {
        return this.fromAddress;
    }

    public Boolean hasCredential() {
        return this.hasCredential;
    }

    public String id() {
        return this.id;
    }

    public String identity() {
        return this.identity;
    }

    public Boolean isArchived() {
        return this.isArchived;
    }

    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public String platform() {
        return this.platform;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.fromAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredential());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmailChannelResponse)) {
            return false;
        }
        EmailChannelResponse other = (EmailChannelResponse)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.fromAddress(), other.fromAddress()) && Objects.equals(this.hasCredential(), other.hasCredential()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.identity(), other.identity()) && Objects.equals(this.isArchived(), other.isArchived()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.fromAddress() != null) {
            sb.append("FromAddress: ").append(this.fromAddress()).append(",");
        }
        if (this.hasCredential() != null) {
            sb.append("HasCredential: ").append(this.hasCredential()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.identity() != null) {
            sb.append("Identity: ").append(this.identity()).append(",");
        }
        if (this.isArchived() != null) {
            sb.append("IsArchived: ").append(this.isArchived()).append(",");
        }
        if (this.lastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.lastModifiedBy()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "FromAddress": {
                return Optional.of(clazz.cast(this.fromAddress()));
            }
            case "HasCredential": {
                return Optional.of(clazz.cast(this.hasCredential()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Identity": {
                return Optional.of(clazz.cast(this.identity()));
            }
            case "IsArchived": {
                return Optional.of(clazz.cast(this.isArchived()));
            }
            case "LastModifiedBy": {
                return Optional.of(clazz.cast(this.lastModifiedBy()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platform()));
            }
            case "RoleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmailChannelResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationDate;
        private Boolean enabled;
        private String fromAddress;
        private Boolean hasCredential;
        private String id;
        private String identity;
        private Boolean isArchived;
        private String lastModifiedBy;
        private String lastModifiedDate;
        private String platform;
        private String roleArn;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(EmailChannelResponse model) {
            this.applicationId(model.applicationId);
            this.creationDate(model.creationDate);
            this.enabled(model.enabled);
            this.fromAddress(model.fromAddress);
            this.hasCredential(model.hasCredential);
            this.id(model.id);
            this.identity(model.identity);
            this.isArchived(model.isArchived);
            this.lastModifiedBy(model.lastModifiedBy);
            this.lastModifiedDate(model.lastModifiedDate);
            this.platform(model.platform);
            this.roleArn(model.roleArn);
            this.version(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getFromAddress() {
            return this.fromAddress;
        }

        @Override
        public final Builder fromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        public final void setFromAddress(String fromAddress) {
            this.fromAddress = fromAddress;
        }

        public final Boolean getHasCredential() {
            return this.hasCredential;
        }

        @Override
        public final Builder hasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
            return this;
        }

        public final void setHasCredential(Boolean hasCredential) {
            this.hasCredential = hasCredential;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getIdentity() {
            return this.identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        public final String getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        @Override
        public final Builder lastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final void setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public EmailChannelResponse build() {
            return new EmailChannelResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EmailChannelResponse> {
        public Builder applicationId(String var1);

        public Builder creationDate(String var1);

        public Builder enabled(Boolean var1);

        public Builder fromAddress(String var1);

        public Builder hasCredential(Boolean var1);

        public Builder id(String var1);

        public Builder identity(String var1);

        public Builder isArchived(Boolean var1);

        public Builder lastModifiedBy(String var1);

        public Builder lastModifiedDate(String var1);

        public Builder platform(String var1);

        public Builder roleArn(String var1);

        public Builder version(Integer var1);
    }
}

