/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.BaiduMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BaiduMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, BaiduMessage> {
    private final String action;
    private final String body;
    private final Map<String, String> data;
    private final String iconReference;
    private final String imageIconUrl;
    private final String imageUrl;
    private final String rawContent;
    private final Boolean silentPush;
    private final String smallImageIconUrl;
    private final String sound;
    private final Map<String, List<String>> substitutions;
    private final String title;
    private final String url;

    private BaiduMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.body = builder.body;
        this.data = builder.data;
        this.iconReference = builder.iconReference;
        this.imageIconUrl = builder.imageIconUrl;
        this.imageUrl = builder.imageUrl;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.smallImageIconUrl = builder.smallImageIconUrl;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.title = builder.title;
        this.url = builder.url;
    }

    public Action action() {
        return Action.fromValue(this.action);
    }

    public String actionString() {
        return this.action;
    }

    public String body() {
        return this.body;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public String iconReference() {
        return this.iconReference;
    }

    public String imageIconUrl() {
        return this.imageIconUrl;
    }

    public String imageUrl() {
        return this.imageUrl;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public Boolean silentPush() {
        return this.silentPush;
    }

    public String smallImageIconUrl() {
        return this.smallImageIconUrl;
    }

    public String sound() {
        return this.sound;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String title() {
        return this.title;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionString());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.silentPush());
        hashCode = 31 * hashCode + Objects.hashCode(this.smallImageIconUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sound());
        hashCode = 31 * hashCode + Objects.hashCode(this.substitutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaiduMessage)) {
            return false;
        }
        BaiduMessage other = (BaiduMessage)obj;
        return Objects.equals(this.actionString(), other.actionString()) && Objects.equals(this.body(), other.body()) && Objects.equals(this.data(), other.data()) && Objects.equals(this.iconReference(), other.iconReference()) && Objects.equals(this.imageIconUrl(), other.imageIconUrl()) && Objects.equals(this.imageUrl(), other.imageUrl()) && Objects.equals(this.rawContent(), other.rawContent()) && Objects.equals(this.silentPush(), other.silentPush()) && Objects.equals(this.smallImageIconUrl(), other.smallImageIconUrl()) && Objects.equals(this.sound(), other.sound()) && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.url(), other.url());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.actionString() != null) {
            sb.append("Action: ").append(this.actionString()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.iconReference() != null) {
            sb.append("IconReference: ").append(this.iconReference()).append(",");
        }
        if (this.imageIconUrl() != null) {
            sb.append("ImageIconUrl: ").append(this.imageIconUrl()).append(",");
        }
        if (this.imageUrl() != null) {
            sb.append("ImageUrl: ").append(this.imageUrl()).append(",");
        }
        if (this.rawContent() != null) {
            sb.append("RawContent: ").append(this.rawContent()).append(",");
        }
        if (this.silentPush() != null) {
            sb.append("SilentPush: ").append(this.silentPush()).append(",");
        }
        if (this.smallImageIconUrl() != null) {
            sb.append("SmallImageIconUrl: ").append(this.smallImageIconUrl()).append(",");
        }
        if (this.sound() != null) {
            sb.append("Sound: ").append(this.sound()).append(",");
        }
        if (this.substitutions() != null) {
            sb.append("Substitutions: ").append(this.substitutions()).append(",");
        }
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.of(clazz.cast(this.actionString()));
            }
            case "Body": {
                return Optional.of(clazz.cast(this.body()));
            }
            case "Data": {
                return Optional.of(clazz.cast(this.data()));
            }
            case "IconReference": {
                return Optional.of(clazz.cast(this.iconReference()));
            }
            case "ImageIconUrl": {
                return Optional.of(clazz.cast(this.imageIconUrl()));
            }
            case "ImageUrl": {
                return Optional.of(clazz.cast(this.imageUrl()));
            }
            case "RawContent": {
                return Optional.of(clazz.cast(this.rawContent()));
            }
            case "SilentPush": {
                return Optional.of(clazz.cast(this.silentPush()));
            }
            case "SmallImageIconUrl": {
                return Optional.of(clazz.cast(this.smallImageIconUrl()));
            }
            case "Sound": {
                return Optional.of(clazz.cast(this.sound()));
            }
            case "Substitutions": {
                return Optional.of(clazz.cast(this.substitutions()));
            }
            case "Title": {
                return Optional.of(clazz.cast(this.title()));
            }
            case "Url": {
                return Optional.of(clazz.cast(this.url()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BaiduMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String body;
        private Map<String, String> data;
        private String iconReference;
        private String imageIconUrl;
        private String imageUrl;
        private String rawContent;
        private Boolean silentPush;
        private String smallImageIconUrl;
        private String sound;
        private Map<String, List<String>> substitutions;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(BaiduMessage model) {
            this.action(model.action);
            this.body(model.body);
            this.data(model.data);
            this.iconReference(model.iconReference);
            this.imageIconUrl(model.imageIconUrl);
            this.imageUrl(model.imageUrl);
            this.rawContent(model.rawContent);
            this.silentPush(model.silentPush);
            this.smallImageIconUrl(model.smallImageIconUrl);
            this.sound(model.sound);
            this.substitutions(model.substitutions);
            this.title(model.title);
            this.url(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, String> getData() {
            return this.data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final String getIconReference() {
            return this.iconReference;
        }

        @Override
        public final Builder iconReference(String iconReference) {
            this.iconReference = iconReference;
            return this;
        }

        public final void setIconReference(String iconReference) {
            this.iconReference = iconReference;
        }

        public final String getImageIconUrl() {
            return this.imageIconUrl;
        }

        @Override
        public final Builder imageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
            return this;
        }

        public final void setImageIconUrl(String imageIconUrl) {
            this.imageIconUrl = imageIconUrl;
        }

        public final String getImageUrl() {
            return this.imageUrl;
        }

        @Override
        public final Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final String getSmallImageIconUrl() {
            return this.smallImageIconUrl;
        }

        @Override
        public final Builder smallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
            return this;
        }

        public final void setSmallImageIconUrl(String smallImageIconUrl) {
            this.smallImageIconUrl = smallImageIconUrl;
        }

        public final String getSound() {
            return this.sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public BaiduMessage build() {
            return new BaiduMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BaiduMessage> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder body(String var1);

        public Builder data(Map<String, String> var1);

        public Builder iconReference(String var1);

        public Builder imageIconUrl(String var1);

        public Builder imageUrl(String var1);

        public Builder rawContent(String var1);

        public Builder silentPush(Boolean var1);

        public Builder smallImageIconUrl(String var1);

        public Builder sound(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

