/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.ApplicationResponse;
import software.amazon.awssdk.services.pinpoint.model.ListOfApplicationResponseCopier;
import software.amazon.awssdk.services.pinpoint.transform.ApplicationsResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationsResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationsResponse> {
    private final List<ApplicationResponse> item;
    private final String nextToken;

    private ApplicationsResponse(BuilderImpl builder) {
        this.item = builder.item;
        this.nextToken = builder.nextToken;
    }

    public List<ApplicationResponse> item() {
        return this.item;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.item());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationsResponse)) {
            return false;
        }
        ApplicationsResponse other = (ApplicationsResponse)obj;
        return Objects.equals(this.item(), other.item()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.item() != null) {
            sb.append("Item: ").append(this.item()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Item": {
                return Optional.of(clazz.cast(this.item()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationsResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ApplicationResponse> item;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationsResponse model) {
            this.item(model.item);
            this.nextToken(model.nextToken);
        }

        public final Collection<ApplicationResponse.Builder> getItem() {
            return this.item != null ? (Collection)this.item.stream().map(ApplicationResponse::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder item(Collection<ApplicationResponse> item) {
            this.item = ListOfApplicationResponseCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(ApplicationResponse ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        public final void setItem(Collection<ApplicationResponse.BuilderImpl> item) {
            this.item = ListOfApplicationResponseCopier.copyFromBuilder(item);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ApplicationsResponse build() {
            return new ApplicationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationsResponse> {
        public Builder item(Collection<ApplicationResponse> var1);

        public Builder item(ApplicationResponse ... var1);

        public Builder nextToken(String var1);
    }
}

