/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.transform.APNSSandboxChannelRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class APNSSandboxChannelRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, APNSSandboxChannelRequest> {
    private final String bundleId;
    private final String certificate;
    private final String defaultAuthenticationMethod;
    private final Boolean enabled;
    private final String privateKey;
    private final String teamId;
    private final String tokenKey;
    private final String tokenKeyId;

    private APNSSandboxChannelRequest(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
        this.certificate = builder.certificate;
        this.defaultAuthenticationMethod = builder.defaultAuthenticationMethod;
        this.enabled = builder.enabled;
        this.privateKey = builder.privateKey;
        this.teamId = builder.teamId;
        this.tokenKey = builder.tokenKey;
        this.tokenKeyId = builder.tokenKeyId;
    }

    public String bundleId() {
        return this.bundleId;
    }

    public String certificate() {
        return this.certificate;
    }

    public String defaultAuthenticationMethod() {
        return this.defaultAuthenticationMethod;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public String teamId() {
        return this.teamId;
    }

    public String tokenKey() {
        return this.tokenKey;
    }

    public String tokenKeyId() {
        return this.tokenKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bundleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultAuthenticationMethod());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.teamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenKeyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSSandboxChannelRequest)) {
            return false;
        }
        APNSSandboxChannelRequest other = (APNSSandboxChannelRequest)obj;
        return Objects.equals(this.bundleId(), other.bundleId()) && Objects.equals(this.certificate(), other.certificate()) && Objects.equals(this.defaultAuthenticationMethod(), other.defaultAuthenticationMethod()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.teamId(), other.teamId()) && Objects.equals(this.tokenKey(), other.tokenKey()) && Objects.equals(this.tokenKeyId(), other.tokenKeyId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bundleId() != null) {
            sb.append("BundleId: ").append(this.bundleId()).append(",");
        }
        if (this.certificate() != null) {
            sb.append("Certificate: ").append(this.certificate()).append(",");
        }
        if (this.defaultAuthenticationMethod() != null) {
            sb.append("DefaultAuthenticationMethod: ").append(this.defaultAuthenticationMethod()).append(",");
        }
        if (this.enabled() != null) {
            sb.append("Enabled: ").append(this.enabled()).append(",");
        }
        if (this.privateKey() != null) {
            sb.append("PrivateKey: ").append(this.privateKey()).append(",");
        }
        if (this.teamId() != null) {
            sb.append("TeamId: ").append(this.teamId()).append(",");
        }
        if (this.tokenKey() != null) {
            sb.append("TokenKey: ").append(this.tokenKey()).append(",");
        }
        if (this.tokenKeyId() != null) {
            sb.append("TokenKeyId: ").append(this.tokenKeyId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BundleId": {
                return Optional.of(clazz.cast(this.bundleId()));
            }
            case "Certificate": {
                return Optional.of(clazz.cast(this.certificate()));
            }
            case "DefaultAuthenticationMethod": {
                return Optional.of(clazz.cast(this.defaultAuthenticationMethod()));
            }
            case "Enabled": {
                return Optional.of(clazz.cast(this.enabled()));
            }
            case "PrivateKey": {
                return Optional.of(clazz.cast(this.privateKey()));
            }
            case "TeamId": {
                return Optional.of(clazz.cast(this.teamId()));
            }
            case "TokenKey": {
                return Optional.of(clazz.cast(this.tokenKey()));
            }
            case "TokenKeyId": {
                return Optional.of(clazz.cast(this.tokenKeyId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        APNSSandboxChannelRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bundleId;
        private String certificate;
        private String defaultAuthenticationMethod;
        private Boolean enabled;
        private String privateKey;
        private String teamId;
        private String tokenKey;
        private String tokenKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSSandboxChannelRequest model) {
            this.bundleId(model.bundleId);
            this.certificate(model.certificate);
            this.defaultAuthenticationMethod(model.defaultAuthenticationMethod);
            this.enabled(model.enabled);
            this.privateKey(model.privateKey);
            this.teamId(model.teamId);
            this.tokenKey(model.tokenKey);
            this.tokenKeyId(model.tokenKeyId);
        }

        public final String getBundleId() {
            return this.bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getDefaultAuthenticationMethod() {
            return this.defaultAuthenticationMethod;
        }

        @Override
        public final Builder defaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
            return this;
        }

        public final void setDefaultAuthenticationMethod(String defaultAuthenticationMethod) {
            this.defaultAuthenticationMethod = defaultAuthenticationMethod;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getTeamId() {
            return this.teamId;
        }

        @Override
        public final Builder teamId(String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        public final String getTokenKey() {
            return this.tokenKey;
        }

        @Override
        public final Builder tokenKey(String tokenKey) {
            this.tokenKey = tokenKey;
            return this;
        }

        public final void setTokenKey(String tokenKey) {
            this.tokenKey = tokenKey;
        }

        public final String getTokenKeyId() {
            return this.tokenKeyId;
        }

        @Override
        public final Builder tokenKeyId(String tokenKeyId) {
            this.tokenKeyId = tokenKeyId;
            return this;
        }

        public final void setTokenKeyId(String tokenKeyId) {
            this.tokenKeyId = tokenKeyId;
        }

        public APNSSandboxChannelRequest build() {
            return new APNSSandboxChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, APNSSandboxChannelRequest> {
        public Builder bundleId(String var1);

        public Builder certificate(String var1);

        public Builder defaultAuthenticationMethod(String var1);

        public Builder enabled(Boolean var1);

        public Builder privateKey(String var1);

        public Builder teamId(String var1);

        public Builder tokenKey(String var1);

        public Builder tokenKeyId(String var1);
    }
}

