/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateGcmChannelRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateGcmChannelRequest> {
    private final String applicationId;
    private final GCMChannelRequest gcmChannelRequest;

    private UpdateGcmChannelRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.gcmChannelRequest = builder.gcmChannelRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public GCMChannelRequest gcmChannelRequest() {
        return this.gcmChannelRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.gcmChannelRequest() == null ? 0 : this.gcmChannelRequest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGcmChannelRequest)) {
            return false;
        }
        UpdateGcmChannelRequest other = (UpdateGcmChannelRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.gcmChannelRequest() == null ^ this.gcmChannelRequest() == null) {
            return false;
        }
        return other.gcmChannelRequest() == null || other.gcmChannelRequest().equals(this.gcmChannelRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.gcmChannelRequest() != null) {
            sb.append("GCMChannelRequest: ").append(this.gcmChannelRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "GCMChannelRequest": {
                return Optional.of(clazz.cast(this.gcmChannelRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private GCMChannelRequest gcmChannelRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGcmChannelRequest model) {
            this.applicationId(model.applicationId);
            this.gcmChannelRequest(model.gcmChannelRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final GCMChannelRequest.Builder getGCMChannelRequest() {
            return this.gcmChannelRequest != null ? this.gcmChannelRequest.toBuilder() : null;
        }

        @Override
        public final Builder gcmChannelRequest(GCMChannelRequest gcmChannelRequest) {
            this.gcmChannelRequest = gcmChannelRequest;
            return this;
        }

        public final void setGCMChannelRequest(GCMChannelRequest.BuilderImpl gcmChannelRequest) {
            this.gcmChannelRequest = gcmChannelRequest != null ? gcmChannelRequest.build() : null;
        }

        public UpdateGcmChannelRequest build() {
            return new UpdateGcmChannelRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateGcmChannelRequest> {
        public Builder applicationId(String var1);

        public Builder gcmChannelRequest(GCMChannelRequest var1);
    }
}

