/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.pinpoint.model.WriteApplicationSettingsRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApplicationSettingsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
    private final String applicationId;
    private final WriteApplicationSettingsRequest writeApplicationSettingsRequest;

    private UpdateApplicationSettingsRequest(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.writeApplicationSettingsRequest = builder.writeApplicationSettingsRequest;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public WriteApplicationSettingsRequest writeApplicationSettingsRequest() {
        return this.writeApplicationSettingsRequest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.writeApplicationSettingsRequest() == null ? 0 : this.writeApplicationSettingsRequest().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationSettingsRequest)) {
            return false;
        }
        UpdateApplicationSettingsRequest other = (UpdateApplicationSettingsRequest)((Object)obj);
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.writeApplicationSettingsRequest() == null ^ this.writeApplicationSettingsRequest() == null) {
            return false;
        }
        return other.writeApplicationSettingsRequest() == null || other.writeApplicationSettingsRequest().equals(this.writeApplicationSettingsRequest());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.writeApplicationSettingsRequest() != null) {
            sb.append("WriteApplicationSettingsRequest: ").append(this.writeApplicationSettingsRequest()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "WriteApplicationSettingsRequest": {
                return Optional.of(clazz.cast(this.writeApplicationSettingsRequest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private WriteApplicationSettingsRequest writeApplicationSettingsRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationSettingsRequest model) {
            this.applicationId(model.applicationId);
            this.writeApplicationSettingsRequest(model.writeApplicationSettingsRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final WriteApplicationSettingsRequest.Builder getWriteApplicationSettingsRequest() {
            return this.writeApplicationSettingsRequest != null ? this.writeApplicationSettingsRequest.toBuilder() : null;
        }

        @Override
        public final Builder writeApplicationSettingsRequest(WriteApplicationSettingsRequest writeApplicationSettingsRequest) {
            this.writeApplicationSettingsRequest = writeApplicationSettingsRequest;
            return this;
        }

        public final void setWriteApplicationSettingsRequest(WriteApplicationSettingsRequest.BuilderImpl writeApplicationSettingsRequest) {
            this.writeApplicationSettingsRequest = writeApplicationSettingsRequest != null ? writeApplicationSettingsRequest.build() : null;
        }

        public UpdateApplicationSettingsRequest build() {
            return new UpdateApplicationSettingsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateApplicationSettingsRequest> {
        public Builder applicationId(String var1);

        public Builder writeApplicationSettingsRequest(WriteApplicationSettingsRequest var1);
    }
}

