/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.SetDimension;
import software.amazon.awssdk.services.pinpoint.transform.SegmentDemographicsMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SegmentDemographics
implements StructuredPojo,
ToCopyableBuilder<Builder, SegmentDemographics> {
    private final SetDimension appVersion;
    private final SetDimension channel;
    private final SetDimension deviceType;
    private final SetDimension make;
    private final SetDimension model;
    private final SetDimension platform;

    private SegmentDemographics(BuilderImpl builder) {
        this.appVersion = builder.appVersion;
        this.channel = builder.channel;
        this.deviceType = builder.deviceType;
        this.make = builder.make;
        this.model = builder.model;
        this.platform = builder.platform;
    }

    public SetDimension appVersion() {
        return this.appVersion;
    }

    public SetDimension channel() {
        return this.channel;
    }

    public SetDimension deviceType() {
        return this.deviceType;
    }

    public SetDimension make() {
        return this.make;
    }

    public SetDimension model() {
        return this.model;
    }

    public SetDimension platform() {
        return this.platform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.appVersion() == null ? 0 : this.appVersion().hashCode());
        hashCode = 31 * hashCode + (this.channel() == null ? 0 : this.channel().hashCode());
        hashCode = 31 * hashCode + (this.deviceType() == null ? 0 : this.deviceType().hashCode());
        hashCode = 31 * hashCode + (this.make() == null ? 0 : this.make().hashCode());
        hashCode = 31 * hashCode + (this.model() == null ? 0 : this.model().hashCode());
        hashCode = 31 * hashCode + (this.platform() == null ? 0 : this.platform().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDemographics)) {
            return false;
        }
        SegmentDemographics other = (SegmentDemographics)obj;
        if (other.appVersion() == null ^ this.appVersion() == null) {
            return false;
        }
        if (other.appVersion() != null && !other.appVersion().equals(this.appVersion())) {
            return false;
        }
        if (other.channel() == null ^ this.channel() == null) {
            return false;
        }
        if (other.channel() != null && !other.channel().equals(this.channel())) {
            return false;
        }
        if (other.deviceType() == null ^ this.deviceType() == null) {
            return false;
        }
        if (other.deviceType() != null && !other.deviceType().equals(this.deviceType())) {
            return false;
        }
        if (other.make() == null ^ this.make() == null) {
            return false;
        }
        if (other.make() != null && !other.make().equals(this.make())) {
            return false;
        }
        if (other.model() == null ^ this.model() == null) {
            return false;
        }
        if (other.model() != null && !other.model().equals(this.model())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        return other.platform() == null || other.platform().equals(this.platform());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.appVersion() != null) {
            sb.append("AppVersion: ").append(this.appVersion()).append(",");
        }
        if (this.channel() != null) {
            sb.append("Channel: ").append(this.channel()).append(",");
        }
        if (this.deviceType() != null) {
            sb.append("DeviceType: ").append(this.deviceType()).append(",");
        }
        if (this.make() != null) {
            sb.append("Make: ").append(this.make()).append(",");
        }
        if (this.model() != null) {
            sb.append("Model: ").append(this.model()).append(",");
        }
        if (this.platform() != null) {
            sb.append("Platform: ").append(this.platform()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppVersion": {
                return Optional.of(clazz.cast(this.appVersion()));
            }
            case "Channel": {
                return Optional.of(clazz.cast(this.channel()));
            }
            case "DeviceType": {
                return Optional.of(clazz.cast(this.deviceType()));
            }
            case "Make": {
                return Optional.of(clazz.cast(this.make()));
            }
            case "Model": {
                return Optional.of(clazz.cast(this.model()));
            }
            case "Platform": {
                return Optional.of(clazz.cast(this.platform()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SegmentDemographicsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private SetDimension appVersion;
        private SetDimension channel;
        private SetDimension deviceType;
        private SetDimension make;
        private SetDimension model;
        private SetDimension platform;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDemographics model) {
            this.appVersion(model.appVersion);
            this.channel(model.channel);
            this.deviceType(model.deviceType);
            this.make(model.make);
            this.model(model.model);
            this.platform(model.platform);
        }

        public final SetDimension.Builder getAppVersion() {
            return this.appVersion != null ? this.appVersion.toBuilder() : null;
        }

        @Override
        public final Builder appVersion(SetDimension appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final void setAppVersion(SetDimension.BuilderImpl appVersion) {
            this.appVersion = appVersion != null ? appVersion.build() : null;
        }

        public final SetDimension.Builder getChannel() {
            return this.channel != null ? this.channel.toBuilder() : null;
        }

        @Override
        public final Builder channel(SetDimension channel) {
            this.channel = channel;
            return this;
        }

        public final void setChannel(SetDimension.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        public final SetDimension.Builder getDeviceType() {
            return this.deviceType != null ? this.deviceType.toBuilder() : null;
        }

        @Override
        public final Builder deviceType(SetDimension deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public final void setDeviceType(SetDimension.BuilderImpl deviceType) {
            this.deviceType = deviceType != null ? deviceType.build() : null;
        }

        public final SetDimension.Builder getMake() {
            return this.make != null ? this.make.toBuilder() : null;
        }

        @Override
        public final Builder make(SetDimension make) {
            this.make = make;
            return this;
        }

        public final void setMake(SetDimension.BuilderImpl make) {
            this.make = make != null ? make.build() : null;
        }

        public final SetDimension.Builder getModel() {
            return this.model != null ? this.model.toBuilder() : null;
        }

        @Override
        public final Builder model(SetDimension model) {
            this.model = model;
            return this;
        }

        public final void setModel(SetDimension.BuilderImpl model) {
            this.model = model != null ? model.build() : null;
        }

        public final SetDimension.Builder getPlatform() {
            return this.platform != null ? this.platform.toBuilder() : null;
        }

        @Override
        public final Builder platform(SetDimension platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(SetDimension.BuilderImpl platform) {
            this.platform = platform != null ? platform.build() : null;
        }

        public SegmentDemographics build() {
            return new SegmentDemographics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SegmentDemographics> {
        public Builder appVersion(SetDimension var1);

        public Builder channel(SetDimension var1);

        public Builder deviceType(SetDimension var1);

        public Builder make(SetDimension var1);

        public Builder model(SetDimension var1);

        public Builder platform(SetDimension var1);
    }
}

