/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Frequency;
import software.amazon.awssdk.services.pinpoint.model.QuietTime;
import software.amazon.awssdk.services.pinpoint.transform.ScheduleMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Schedule
implements StructuredPojo,
ToCopyableBuilder<Builder, Schedule> {
    private final String endTime;
    private final String frequency;
    private final Boolean isLocalTime;
    private final QuietTime quietTime;
    private final String startTime;
    private final String timezone;

    private Schedule(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.frequency = builder.frequency;
        this.isLocalTime = builder.isLocalTime;
        this.quietTime = builder.quietTime;
        this.startTime = builder.startTime;
        this.timezone = builder.timezone;
    }

    public String endTime() {
        return this.endTime;
    }

    public Frequency frequency() {
        return Frequency.fromValue(this.frequency);
    }

    public String frequencyString() {
        return this.frequency;
    }

    public Boolean isLocalTime() {
        return this.isLocalTime;
    }

    public QuietTime quietTime() {
        return this.quietTime;
    }

    public String startTime() {
        return this.startTime;
    }

    public String timezone() {
        return this.timezone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.frequencyString() == null ? 0 : this.frequencyString().hashCode());
        hashCode = 31 * hashCode + (this.isLocalTime() == null ? 0 : this.isLocalTime().hashCode());
        hashCode = 31 * hashCode + (this.quietTime() == null ? 0 : this.quietTime().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.timezone() == null ? 0 : this.timezone().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule)obj;
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.frequencyString() == null ^ this.frequencyString() == null) {
            return false;
        }
        if (other.frequencyString() != null && !other.frequencyString().equals(this.frequencyString())) {
            return false;
        }
        if (other.isLocalTime() == null ^ this.isLocalTime() == null) {
            return false;
        }
        if (other.isLocalTime() != null && !other.isLocalTime().equals(this.isLocalTime())) {
            return false;
        }
        if (other.quietTime() == null ^ this.quietTime() == null) {
            return false;
        }
        if (other.quietTime() != null && !other.quietTime().equals(this.quietTime())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.timezone() == null ^ this.timezone() == null) {
            return false;
        }
        return other.timezone() == null || other.timezone().equals(this.timezone());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.frequencyString() != null) {
            sb.append("Frequency: ").append(this.frequencyString()).append(",");
        }
        if (this.isLocalTime() != null) {
            sb.append("IsLocalTime: ").append(this.isLocalTime()).append(",");
        }
        if (this.quietTime() != null) {
            sb.append("QuietTime: ").append(this.quietTime()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.timezone() != null) {
            sb.append("Timezone: ").append(this.timezone()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndTime": {
                return Optional.of(clazz.cast(this.endTime()));
            }
            case "Frequency": {
                return Optional.of(clazz.cast(this.frequencyString()));
            }
            case "IsLocalTime": {
                return Optional.of(clazz.cast(this.isLocalTime()));
            }
            case "QuietTime": {
                return Optional.of(clazz.cast(this.quietTime()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "Timezone": {
                return Optional.of(clazz.cast(this.timezone()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ScheduleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String endTime;
        private String frequency;
        private Boolean isLocalTime;
        private QuietTime quietTime;
        private String startTime;
        private String timezone;

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            this.endTime(model.endTime);
            this.frequency(model.frequency);
            this.isLocalTime(model.isLocalTime);
            this.quietTime(model.quietTime);
            this.startTime(model.startTime);
            this.timezone(model.timezone);
        }

        public final String getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final String getFrequency() {
            return this.frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(Frequency frequency) {
            this.frequency(frequency.toString());
            return this;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        public final Boolean getIsLocalTime() {
            return this.isLocalTime;
        }

        @Override
        public final Builder isLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
            return this;
        }

        public final void setIsLocalTime(Boolean isLocalTime) {
            this.isLocalTime = isLocalTime;
        }

        public final QuietTime.Builder getQuietTime() {
            return this.quietTime != null ? this.quietTime.toBuilder() : null;
        }

        @Override
        public final Builder quietTime(QuietTime quietTime) {
            this.quietTime = quietTime;
            return this;
        }

        public final void setQuietTime(QuietTime.BuilderImpl quietTime) {
            this.quietTime = quietTime != null ? quietTime.build() : null;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getTimezone() {
            return this.timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        public Schedule build() {
            return new Schedule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Schedule> {
        public Builder endTime(String var1);

        public Builder frequency(String var1);

        public Builder frequency(Frequency var1);

        public Builder isLocalTime(Boolean var1);

        public Builder quietTime(QuietTime var1);

        public Builder startTime(String var1);

        public Builder timezone(String var1);
    }
}

