/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.ImportJobResource;
import software.amazon.awssdk.services.pinpoint.model.JobStatus;
import software.amazon.awssdk.services.pinpoint.model.ListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.ImportJobResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportJobResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, ImportJobResponse> {
    private final String applicationId;
    private final Integer completedPieces;
    private final String completionDate;
    private final String creationDate;
    private final ImportJobResource definition;
    private final Integer failedPieces;
    private final List<String> failures;
    private final String id;
    private final String jobStatus;
    private final Integer totalFailures;
    private final Integer totalPieces;
    private final Integer totalProcessed;
    private final String type;

    private ImportJobResponse(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.completedPieces = builder.completedPieces;
        this.completionDate = builder.completionDate;
        this.creationDate = builder.creationDate;
        this.definition = builder.definition;
        this.failedPieces = builder.failedPieces;
        this.failures = builder.failures;
        this.id = builder.id;
        this.jobStatus = builder.jobStatus;
        this.totalFailures = builder.totalFailures;
        this.totalPieces = builder.totalPieces;
        this.totalProcessed = builder.totalProcessed;
        this.type = builder.type;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public Integer completedPieces() {
        return this.completedPieces;
    }

    public String completionDate() {
        return this.completionDate;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public ImportJobResource definition() {
        return this.definition;
    }

    public Integer failedPieces() {
        return this.failedPieces;
    }

    public List<String> failures() {
        return this.failures;
    }

    public String id() {
        return this.id;
    }

    public JobStatus jobStatus() {
        return JobStatus.fromValue(this.jobStatus);
    }

    public String jobStatusString() {
        return this.jobStatus;
    }

    public Integer totalFailures() {
        return this.totalFailures;
    }

    public Integer totalPieces() {
        return this.totalPieces;
    }

    public Integer totalProcessed() {
        return this.totalProcessed;
    }

    public String type() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.completedPieces() == null ? 0 : this.completedPieces().hashCode());
        hashCode = 31 * hashCode + (this.completionDate() == null ? 0 : this.completionDate().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.definition() == null ? 0 : this.definition().hashCode());
        hashCode = 31 * hashCode + (this.failedPieces() == null ? 0 : this.failedPieces().hashCode());
        hashCode = 31 * hashCode + (this.failures() == null ? 0 : this.failures().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.jobStatusString() == null ? 0 : this.jobStatusString().hashCode());
        hashCode = 31 * hashCode + (this.totalFailures() == null ? 0 : this.totalFailures().hashCode());
        hashCode = 31 * hashCode + (this.totalPieces() == null ? 0 : this.totalPieces().hashCode());
        hashCode = 31 * hashCode + (this.totalProcessed() == null ? 0 : this.totalProcessed().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobResponse)) {
            return false;
        }
        ImportJobResponse other = (ImportJobResponse)obj;
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.completedPieces() == null ^ this.completedPieces() == null) {
            return false;
        }
        if (other.completedPieces() != null && !other.completedPieces().equals(this.completedPieces())) {
            return false;
        }
        if (other.completionDate() == null ^ this.completionDate() == null) {
            return false;
        }
        if (other.completionDate() != null && !other.completionDate().equals(this.completionDate())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.definition() == null ^ this.definition() == null) {
            return false;
        }
        if (other.definition() != null && !other.definition().equals(this.definition())) {
            return false;
        }
        if (other.failedPieces() == null ^ this.failedPieces() == null) {
            return false;
        }
        if (other.failedPieces() != null && !other.failedPieces().equals(this.failedPieces())) {
            return false;
        }
        if (other.failures() == null ^ this.failures() == null) {
            return false;
        }
        if (other.failures() != null && !other.failures().equals(this.failures())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.jobStatusString() == null ^ this.jobStatusString() == null) {
            return false;
        }
        if (other.jobStatusString() != null && !other.jobStatusString().equals(this.jobStatusString())) {
            return false;
        }
        if (other.totalFailures() == null ^ this.totalFailures() == null) {
            return false;
        }
        if (other.totalFailures() != null && !other.totalFailures().equals(this.totalFailures())) {
            return false;
        }
        if (other.totalPieces() == null ^ this.totalPieces() == null) {
            return false;
        }
        if (other.totalPieces() != null && !other.totalPieces().equals(this.totalPieces())) {
            return false;
        }
        if (other.totalProcessed() == null ^ this.totalProcessed() == null) {
            return false;
        }
        if (other.totalProcessed() != null && !other.totalProcessed().equals(this.totalProcessed())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        return other.type() == null || other.type().equals(this.type());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.completedPieces() != null) {
            sb.append("CompletedPieces: ").append(this.completedPieces()).append(",");
        }
        if (this.completionDate() != null) {
            sb.append("CompletionDate: ").append(this.completionDate()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.definition() != null) {
            sb.append("Definition: ").append(this.definition()).append(",");
        }
        if (this.failedPieces() != null) {
            sb.append("FailedPieces: ").append(this.failedPieces()).append(",");
        }
        if (this.failures() != null) {
            sb.append("Failures: ").append(this.failures()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.jobStatusString() != null) {
            sb.append("JobStatus: ").append(this.jobStatusString()).append(",");
        }
        if (this.totalFailures() != null) {
            sb.append("TotalFailures: ").append(this.totalFailures()).append(",");
        }
        if (this.totalPieces() != null) {
            sb.append("TotalPieces: ").append(this.totalPieces()).append(",");
        }
        if (this.totalProcessed() != null) {
            sb.append("TotalProcessed: ").append(this.totalProcessed()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CompletedPieces": {
                return Optional.of(clazz.cast(this.completedPieces()));
            }
            case "CompletionDate": {
                return Optional.of(clazz.cast(this.completionDate()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "Definition": {
                return Optional.of(clazz.cast(this.definition()));
            }
            case "FailedPieces": {
                return Optional.of(clazz.cast(this.failedPieces()));
            }
            case "Failures": {
                return Optional.of(clazz.cast(this.failures()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "JobStatus": {
                return Optional.of(clazz.cast(this.jobStatusString()));
            }
            case "TotalFailures": {
                return Optional.of(clazz.cast(this.totalFailures()));
            }
            case "TotalPieces": {
                return Optional.of(clazz.cast(this.totalPieces()));
            }
            case "TotalProcessed": {
                return Optional.of(clazz.cast(this.totalProcessed()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImportJobResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private Integer completedPieces;
        private String completionDate;
        private String creationDate;
        private ImportJobResource definition;
        private Integer failedPieces;
        private List<String> failures;
        private String id;
        private String jobStatus;
        private Integer totalFailures;
        private Integer totalPieces;
        private Integer totalProcessed;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobResponse model) {
            this.applicationId(model.applicationId);
            this.completedPieces(model.completedPieces);
            this.completionDate(model.completionDate);
            this.creationDate(model.creationDate);
            this.definition(model.definition);
            this.failedPieces(model.failedPieces);
            this.failures(model.failures);
            this.id(model.id);
            this.jobStatus(model.jobStatus);
            this.totalFailures(model.totalFailures);
            this.totalPieces(model.totalPieces);
            this.totalProcessed(model.totalProcessed);
            this.type(model.type);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Integer getCompletedPieces() {
            return this.completedPieces;
        }

        @Override
        public final Builder completedPieces(Integer completedPieces) {
            this.completedPieces = completedPieces;
            return this;
        }

        public final void setCompletedPieces(Integer completedPieces) {
            this.completedPieces = completedPieces;
        }

        public final String getCompletionDate() {
            return this.completionDate;
        }

        @Override
        public final Builder completionDate(String completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final void setCompletionDate(String completionDate) {
            this.completionDate = completionDate;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final ImportJobResource.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(ImportJobResource definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(ImportJobResource.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final Integer getFailedPieces() {
            return this.failedPieces;
        }

        @Override
        public final Builder failedPieces(Integer failedPieces) {
            this.failedPieces = failedPieces;
            return this;
        }

        public final void setFailedPieces(Integer failedPieces) {
            this.failedPieces = failedPieces;
        }

        public final Collection<String> getFailures() {
            return this.failures;
        }

        @Override
        public final Builder failures(Collection<String> failures) {
            this.failures = ListOf__stringCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(String ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        public final void setFailures(Collection<String> failures) {
            this.failures = ListOf__stringCopier.copy(failures);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final Integer getTotalFailures() {
            return this.totalFailures;
        }

        @Override
        public final Builder totalFailures(Integer totalFailures) {
            this.totalFailures = totalFailures;
            return this;
        }

        public final void setTotalFailures(Integer totalFailures) {
            this.totalFailures = totalFailures;
        }

        public final Integer getTotalPieces() {
            return this.totalPieces;
        }

        @Override
        public final Builder totalPieces(Integer totalPieces) {
            this.totalPieces = totalPieces;
            return this;
        }

        public final void setTotalPieces(Integer totalPieces) {
            this.totalPieces = totalPieces;
        }

        public final Integer getTotalProcessed() {
            return this.totalProcessed;
        }

        @Override
        public final Builder totalProcessed(Integer totalProcessed) {
            this.totalProcessed = totalProcessed;
            return this;
        }

        public final void setTotalProcessed(Integer totalProcessed) {
            this.totalProcessed = totalProcessed;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public ImportJobResponse build() {
            return new ImportJobResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportJobResponse> {
        public Builder applicationId(String var1);

        public Builder completedPieces(Integer var1);

        public Builder completionDate(String var1);

        public Builder creationDate(String var1);

        public Builder definition(ImportJobResource var1);

        public Builder failedPieces(Integer var1);

        public Builder failures(Collection<String> var1);

        public Builder failures(String ... var1);

        public Builder id(String var1);

        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatus var1);

        public Builder totalFailures(Integer var1);

        public Builder totalPieces(Integer var1);

        public Builder totalProcessed(Integer var1);

        public Builder type(String var1);
    }
}

