/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignLimits;
import software.amazon.awssdk.services.pinpoint.model.CampaignState;
import software.amazon.awssdk.services.pinpoint.model.ListOfTreatmentResourceCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageConfiguration;
import software.amazon.awssdk.services.pinpoint.model.Schedule;
import software.amazon.awssdk.services.pinpoint.model.TreatmentResource;
import software.amazon.awssdk.services.pinpoint.transform.CampaignResponseMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CampaignResponse
implements StructuredPojo,
ToCopyableBuilder<Builder, CampaignResponse> {
    private final List<TreatmentResource> additionalTreatments;
    private final String applicationId;
    private final String creationDate;
    private final CampaignState defaultState;
    private final String description;
    private final Integer holdoutPercent;
    private final String id;
    private final Boolean isPaused;
    private final String lastModifiedDate;
    private final CampaignLimits limits;
    private final MessageConfiguration messageConfiguration;
    private final String name;
    private final Schedule schedule;
    private final String segmentId;
    private final Integer segmentVersion;
    private final CampaignState state;
    private final String treatmentDescription;
    private final String treatmentName;
    private final Integer version;

    private CampaignResponse(BuilderImpl builder) {
        this.additionalTreatments = builder.additionalTreatments;
        this.applicationId = builder.applicationId;
        this.creationDate = builder.creationDate;
        this.defaultState = builder.defaultState;
        this.description = builder.description;
        this.holdoutPercent = builder.holdoutPercent;
        this.id = builder.id;
        this.isPaused = builder.isPaused;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.limits = builder.limits;
        this.messageConfiguration = builder.messageConfiguration;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.segmentId = builder.segmentId;
        this.segmentVersion = builder.segmentVersion;
        this.state = builder.state;
        this.treatmentDescription = builder.treatmentDescription;
        this.treatmentName = builder.treatmentName;
        this.version = builder.version;
    }

    public List<TreatmentResource> additionalTreatments() {
        return this.additionalTreatments;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationDate() {
        return this.creationDate;
    }

    public CampaignState defaultState() {
        return this.defaultState;
    }

    public String description() {
        return this.description;
    }

    public Integer holdoutPercent() {
        return this.holdoutPercent;
    }

    public String id() {
        return this.id;
    }

    public Boolean isPaused() {
        return this.isPaused;
    }

    public String lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public CampaignLimits limits() {
        return this.limits;
    }

    public MessageConfiguration messageConfiguration() {
        return this.messageConfiguration;
    }

    public String name() {
        return this.name;
    }

    public Schedule schedule() {
        return this.schedule;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public Integer segmentVersion() {
        return this.segmentVersion;
    }

    public CampaignState state() {
        return this.state;
    }

    public String treatmentDescription() {
        return this.treatmentDescription;
    }

    public String treatmentName() {
        return this.treatmentName;
    }

    public Integer version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.additionalTreatments() == null ? 0 : this.additionalTreatments().hashCode());
        hashCode = 31 * hashCode + (this.applicationId() == null ? 0 : this.applicationId().hashCode());
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.defaultState() == null ? 0 : this.defaultState().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.holdoutPercent() == null ? 0 : this.holdoutPercent().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.isPaused() == null ? 0 : this.isPaused().hashCode());
        hashCode = 31 * hashCode + (this.lastModifiedDate() == null ? 0 : this.lastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.limits() == null ? 0 : this.limits().hashCode());
        hashCode = 31 * hashCode + (this.messageConfiguration() == null ? 0 : this.messageConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.schedule() == null ? 0 : this.schedule().hashCode());
        hashCode = 31 * hashCode + (this.segmentId() == null ? 0 : this.segmentId().hashCode());
        hashCode = 31 * hashCode + (this.segmentVersion() == null ? 0 : this.segmentVersion().hashCode());
        hashCode = 31 * hashCode + (this.state() == null ? 0 : this.state().hashCode());
        hashCode = 31 * hashCode + (this.treatmentDescription() == null ? 0 : this.treatmentDescription().hashCode());
        hashCode = 31 * hashCode + (this.treatmentName() == null ? 0 : this.treatmentName().hashCode());
        hashCode = 31 * hashCode + (this.version() == null ? 0 : this.version().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CampaignResponse)) {
            return false;
        }
        CampaignResponse other = (CampaignResponse)obj;
        if (other.additionalTreatments() == null ^ this.additionalTreatments() == null) {
            return false;
        }
        if (other.additionalTreatments() != null && !other.additionalTreatments().equals(this.additionalTreatments())) {
            return false;
        }
        if (other.applicationId() == null ^ this.applicationId() == null) {
            return false;
        }
        if (other.applicationId() != null && !other.applicationId().equals(this.applicationId())) {
            return false;
        }
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.defaultState() == null ^ this.defaultState() == null) {
            return false;
        }
        if (other.defaultState() != null && !other.defaultState().equals(this.defaultState())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.holdoutPercent() == null ^ this.holdoutPercent() == null) {
            return false;
        }
        if (other.holdoutPercent() != null && !other.holdoutPercent().equals(this.holdoutPercent())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.isPaused() == null ^ this.isPaused() == null) {
            return false;
        }
        if (other.isPaused() != null && !other.isPaused().equals(this.isPaused())) {
            return false;
        }
        if (other.lastModifiedDate() == null ^ this.lastModifiedDate() == null) {
            return false;
        }
        if (other.lastModifiedDate() != null && !other.lastModifiedDate().equals(this.lastModifiedDate())) {
            return false;
        }
        if (other.limits() == null ^ this.limits() == null) {
            return false;
        }
        if (other.limits() != null && !other.limits().equals(this.limits())) {
            return false;
        }
        if (other.messageConfiguration() == null ^ this.messageConfiguration() == null) {
            return false;
        }
        if (other.messageConfiguration() != null && !other.messageConfiguration().equals(this.messageConfiguration())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.schedule() == null ^ this.schedule() == null) {
            return false;
        }
        if (other.schedule() != null && !other.schedule().equals(this.schedule())) {
            return false;
        }
        if (other.segmentId() == null ^ this.segmentId() == null) {
            return false;
        }
        if (other.segmentId() != null && !other.segmentId().equals(this.segmentId())) {
            return false;
        }
        if (other.segmentVersion() == null ^ this.segmentVersion() == null) {
            return false;
        }
        if (other.segmentVersion() != null && !other.segmentVersion().equals(this.segmentVersion())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.treatmentDescription() == null ^ this.treatmentDescription() == null) {
            return false;
        }
        if (other.treatmentDescription() != null && !other.treatmentDescription().equals(this.treatmentDescription())) {
            return false;
        }
        if (other.treatmentName() == null ^ this.treatmentName() == null) {
            return false;
        }
        if (other.treatmentName() != null && !other.treatmentName().equals(this.treatmentName())) {
            return false;
        }
        if (other.version() == null ^ this.version() == null) {
            return false;
        }
        return other.version() == null || other.version().equals(this.version());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.additionalTreatments() != null) {
            sb.append("AdditionalTreatments: ").append(this.additionalTreatments()).append(",");
        }
        if (this.applicationId() != null) {
            sb.append("ApplicationId: ").append(this.applicationId()).append(",");
        }
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.defaultState() != null) {
            sb.append("DefaultState: ").append(this.defaultState()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.holdoutPercent() != null) {
            sb.append("HoldoutPercent: ").append(this.holdoutPercent()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.isPaused() != null) {
            sb.append("IsPaused: ").append(this.isPaused()).append(",");
        }
        if (this.lastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.lastModifiedDate()).append(",");
        }
        if (this.limits() != null) {
            sb.append("Limits: ").append(this.limits()).append(",");
        }
        if (this.messageConfiguration() != null) {
            sb.append("MessageConfiguration: ").append(this.messageConfiguration()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.schedule() != null) {
            sb.append("Schedule: ").append(this.schedule()).append(",");
        }
        if (this.segmentId() != null) {
            sb.append("SegmentId: ").append(this.segmentId()).append(",");
        }
        if (this.segmentVersion() != null) {
            sb.append("SegmentVersion: ").append(this.segmentVersion()).append(",");
        }
        if (this.state() != null) {
            sb.append("State: ").append(this.state()).append(",");
        }
        if (this.treatmentDescription() != null) {
            sb.append("TreatmentDescription: ").append(this.treatmentDescription()).append(",");
        }
        if (this.treatmentName() != null) {
            sb.append("TreatmentName: ").append(this.treatmentName()).append(",");
        }
        if (this.version() != null) {
            sb.append("Version: ").append(this.version()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdditionalTreatments": {
                return Optional.of(clazz.cast(this.additionalTreatments()));
            }
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "DefaultState": {
                return Optional.of(clazz.cast(this.defaultState()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "HoldoutPercent": {
                return Optional.of(clazz.cast(this.holdoutPercent()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "IsPaused": {
                return Optional.of(clazz.cast(this.isPaused()));
            }
            case "LastModifiedDate": {
                return Optional.of(clazz.cast(this.lastModifiedDate()));
            }
            case "Limits": {
                return Optional.of(clazz.cast(this.limits()));
            }
            case "MessageConfiguration": {
                return Optional.of(clazz.cast(this.messageConfiguration()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Schedule": {
                return Optional.of(clazz.cast(this.schedule()));
            }
            case "SegmentId": {
                return Optional.of(clazz.cast(this.segmentId()));
            }
            case "SegmentVersion": {
                return Optional.of(clazz.cast(this.segmentVersion()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.state()));
            }
            case "TreatmentDescription": {
                return Optional.of(clazz.cast(this.treatmentDescription()));
            }
            case "TreatmentName": {
                return Optional.of(clazz.cast(this.treatmentName()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CampaignResponseMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TreatmentResource> additionalTreatments;
        private String applicationId;
        private String creationDate;
        private CampaignState defaultState;
        private String description;
        private Integer holdoutPercent;
        private String id;
        private Boolean isPaused;
        private String lastModifiedDate;
        private CampaignLimits limits;
        private MessageConfiguration messageConfiguration;
        private String name;
        private Schedule schedule;
        private String segmentId;
        private Integer segmentVersion;
        private CampaignState state;
        private String treatmentDescription;
        private String treatmentName;
        private Integer version;

        private BuilderImpl() {
        }

        private BuilderImpl(CampaignResponse model) {
            this.additionalTreatments(model.additionalTreatments);
            this.applicationId(model.applicationId);
            this.creationDate(model.creationDate);
            this.defaultState(model.defaultState);
            this.description(model.description);
            this.holdoutPercent(model.holdoutPercent);
            this.id(model.id);
            this.isPaused(model.isPaused);
            this.lastModifiedDate(model.lastModifiedDate);
            this.limits(model.limits);
            this.messageConfiguration(model.messageConfiguration);
            this.name(model.name);
            this.schedule(model.schedule);
            this.segmentId(model.segmentId);
            this.segmentVersion(model.segmentVersion);
            this.state(model.state);
            this.treatmentDescription(model.treatmentDescription);
            this.treatmentName(model.treatmentName);
            this.version(model.version);
        }

        public final Collection<TreatmentResource.Builder> getAdditionalTreatments() {
            return this.additionalTreatments != null ? (Collection)this.additionalTreatments.stream().map(TreatmentResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalTreatments(Collection<TreatmentResource> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copy(additionalTreatments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalTreatments(TreatmentResource ... additionalTreatments) {
            this.additionalTreatments(Arrays.asList(additionalTreatments));
            return this;
        }

        public final void setAdditionalTreatments(Collection<TreatmentResource.BuilderImpl> additionalTreatments) {
            this.additionalTreatments = ListOfTreatmentResourceCopier.copyFromBuilder(additionalTreatments);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(String creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(String creationDate) {
            this.creationDate = creationDate;
        }

        public final CampaignState.Builder getDefaultState() {
            return this.defaultState != null ? this.defaultState.toBuilder() : null;
        }

        @Override
        public final Builder defaultState(CampaignState defaultState) {
            this.defaultState = defaultState;
            return this;
        }

        public final void setDefaultState(CampaignState.BuilderImpl defaultState) {
            this.defaultState = defaultState != null ? defaultState.build() : null;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getHoldoutPercent() {
            return this.holdoutPercent;
        }

        @Override
        public final Builder holdoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
            return this;
        }

        public final void setHoldoutPercent(Integer holdoutPercent) {
            this.holdoutPercent = holdoutPercent;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIsPaused() {
            return this.isPaused;
        }

        @Override
        public final Builder isPaused(Boolean isPaused) {
            this.isPaused = isPaused;
            return this;
        }

        public final void setIsPaused(Boolean isPaused) {
            this.isPaused = isPaused;
        }

        public final String getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(String lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final CampaignLimits.Builder getLimits() {
            return this.limits != null ? this.limits.toBuilder() : null;
        }

        @Override
        public final Builder limits(CampaignLimits limits) {
            this.limits = limits;
            return this;
        }

        public final void setLimits(CampaignLimits.BuilderImpl limits) {
            this.limits = limits != null ? limits.build() : null;
        }

        public final MessageConfiguration.Builder getMessageConfiguration() {
            return this.messageConfiguration != null ? this.messageConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder messageConfiguration(MessageConfiguration messageConfiguration) {
            this.messageConfiguration = messageConfiguration;
            return this;
        }

        public final void setMessageConfiguration(MessageConfiguration.BuilderImpl messageConfiguration) {
            this.messageConfiguration = messageConfiguration != null ? messageConfiguration.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Schedule.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final Integer getSegmentVersion() {
            return this.segmentVersion;
        }

        @Override
        public final Builder segmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        public final void setSegmentVersion(Integer segmentVersion) {
            this.segmentVersion = segmentVersion;
        }

        public final CampaignState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        @Override
        public final Builder state(CampaignState state) {
            this.state = state;
            return this;
        }

        public final void setState(CampaignState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        public final String getTreatmentDescription() {
            return this.treatmentDescription;
        }

        @Override
        public final Builder treatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
            return this;
        }

        public final void setTreatmentDescription(String treatmentDescription) {
            this.treatmentDescription = treatmentDescription;
        }

        public final String getTreatmentName() {
            return this.treatmentName;
        }

        @Override
        public final Builder treatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
            return this;
        }

        public final void setTreatmentName(String treatmentName) {
            this.treatmentName = treatmentName;
        }

        public final Integer getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        public CampaignResponse build() {
            return new CampaignResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CampaignResponse> {
        public Builder additionalTreatments(Collection<TreatmentResource> var1);

        public Builder additionalTreatments(TreatmentResource ... var1);

        public Builder applicationId(String var1);

        public Builder creationDate(String var1);

        public Builder defaultState(CampaignState var1);

        public Builder description(String var1);

        public Builder holdoutPercent(Integer var1);

        public Builder id(String var1);

        public Builder isPaused(Boolean var1);

        public Builder lastModifiedDate(String var1);

        public Builder limits(CampaignLimits var1);

        public Builder messageConfiguration(MessageConfiguration var1);

        public Builder name(String var1);

        public Builder schedule(Schedule var1);

        public Builder segmentId(String var1);

        public Builder segmentVersion(Integer var1);

        public Builder state(CampaignState var1);

        public Builder treatmentDescription(String var1);

        public Builder treatmentName(String var1);

        public Builder version(Integer var1);
    }
}

