/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.ChannelType;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.AddressConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddressConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, AddressConfiguration> {
    private final String bodyOverride;
    private final String channelType;
    private final Map<String, String> context;
    private final String rawContent;
    private final Map<String, List<String>> substitutions;
    private final String titleOverride;

    private AddressConfiguration(BuilderImpl builder) {
        this.bodyOverride = builder.bodyOverride;
        this.channelType = builder.channelType;
        this.context = builder.context;
        this.rawContent = builder.rawContent;
        this.substitutions = builder.substitutions;
        this.titleOverride = builder.titleOverride;
    }

    public String bodyOverride() {
        return this.bodyOverride;
    }

    public ChannelType channelType() {
        return ChannelType.fromValue(this.channelType);
    }

    public String channelTypeString() {
        return this.channelType;
    }

    public Map<String, String> context() {
        return this.context;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String titleOverride() {
        return this.titleOverride;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.bodyOverride() == null ? 0 : this.bodyOverride().hashCode());
        hashCode = 31 * hashCode + (this.channelTypeString() == null ? 0 : this.channelTypeString().hashCode());
        hashCode = 31 * hashCode + (this.context() == null ? 0 : this.context().hashCode());
        hashCode = 31 * hashCode + (this.rawContent() == null ? 0 : this.rawContent().hashCode());
        hashCode = 31 * hashCode + (this.substitutions() == null ? 0 : this.substitutions().hashCode());
        hashCode = 31 * hashCode + (this.titleOverride() == null ? 0 : this.titleOverride().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressConfiguration)) {
            return false;
        }
        AddressConfiguration other = (AddressConfiguration)obj;
        if (other.bodyOverride() == null ^ this.bodyOverride() == null) {
            return false;
        }
        if (other.bodyOverride() != null && !other.bodyOverride().equals(this.bodyOverride())) {
            return false;
        }
        if (other.channelTypeString() == null ^ this.channelTypeString() == null) {
            return false;
        }
        if (other.channelTypeString() != null && !other.channelTypeString().equals(this.channelTypeString())) {
            return false;
        }
        if (other.context() == null ^ this.context() == null) {
            return false;
        }
        if (other.context() != null && !other.context().equals(this.context())) {
            return false;
        }
        if (other.rawContent() == null ^ this.rawContent() == null) {
            return false;
        }
        if (other.rawContent() != null && !other.rawContent().equals(this.rawContent())) {
            return false;
        }
        if (other.substitutions() == null ^ this.substitutions() == null) {
            return false;
        }
        if (other.substitutions() != null && !other.substitutions().equals(this.substitutions())) {
            return false;
        }
        if (other.titleOverride() == null ^ this.titleOverride() == null) {
            return false;
        }
        return other.titleOverride() == null || other.titleOverride().equals(this.titleOverride());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.bodyOverride() != null) {
            sb.append("BodyOverride: ").append(this.bodyOverride()).append(",");
        }
        if (this.channelTypeString() != null) {
            sb.append("ChannelType: ").append(this.channelTypeString()).append(",");
        }
        if (this.context() != null) {
            sb.append("Context: ").append(this.context()).append(",");
        }
        if (this.rawContent() != null) {
            sb.append("RawContent: ").append(this.rawContent()).append(",");
        }
        if (this.substitutions() != null) {
            sb.append("Substitutions: ").append(this.substitutions()).append(",");
        }
        if (this.titleOverride() != null) {
            sb.append("TitleOverride: ").append(this.titleOverride()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BodyOverride": {
                return Optional.of(clazz.cast(this.bodyOverride()));
            }
            case "ChannelType": {
                return Optional.of(clazz.cast(this.channelTypeString()));
            }
            case "Context": {
                return Optional.of(clazz.cast(this.context()));
            }
            case "RawContent": {
                return Optional.of(clazz.cast(this.rawContent()));
            }
            case "Substitutions": {
                return Optional.of(clazz.cast(this.substitutions()));
            }
            case "TitleOverride": {
                return Optional.of(clazz.cast(this.titleOverride()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddressConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String bodyOverride;
        private String channelType;
        private Map<String, String> context;
        private String rawContent;
        private Map<String, List<String>> substitutions;
        private String titleOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(AddressConfiguration model) {
            this.bodyOverride(model.bodyOverride);
            this.channelType(model.channelType);
            this.context(model.context);
            this.rawContent(model.rawContent);
            this.substitutions(model.substitutions);
            this.titleOverride(model.titleOverride);
        }

        public final String getBodyOverride() {
            return this.bodyOverride;
        }

        @Override
        public final Builder bodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
            return this;
        }

        public final void setBodyOverride(String bodyOverride) {
            this.bodyOverride = bodyOverride;
        }

        public final String getChannelType() {
            return this.channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType.toString());
            return this;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        public final Map<String, String> getContext() {
            return this.context;
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
            return this;
        }

        public final void setContext(Map<String, String> context) {
            this.context = MapOf__stringCopier.copy(context);
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getTitleOverride() {
            return this.titleOverride;
        }

        @Override
        public final Builder titleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
            return this;
        }

        public final void setTitleOverride(String titleOverride) {
            this.titleOverride = titleOverride;
        }

        public AddressConfiguration build() {
            return new AddressConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddressConfiguration> {
        public Builder bodyOverride(String var1);

        public Builder channelType(String var1);

        public Builder channelType(ChannelType var1);

        public Builder context(Map<String, String> var1);

        public Builder rawContent(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder titleOverride(String var1);
    }
}

