/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.AmazonServiceException;
import software.amazon.awssdk.core.SdkBaseException;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.ClientExecutionParams;
import software.amazon.awssdk.core.client.ClientHandler;
import software.amazon.awssdk.core.client.SdkClientHandler;
import software.amazon.awssdk.core.config.ClientConfiguration;
import software.amazon.awssdk.core.config.SyncClientConfiguration;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.core.runtime.http.response.JsonResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.PinpointClient;
import software.amazon.awssdk.services.pinpoint.model.BadRequestException;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.CreateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.DeleteSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.ForbiddenException;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignActivitiesResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetCampaignsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.GetEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobResponse;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentImportJobsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentsResponse;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.GetSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.InternalServerErrorException;
import software.amazon.awssdk.services.pinpoint.model.MethodNotAllowedException;
import software.amazon.awssdk.services.pinpoint.model.NotFoundException;
import software.amazon.awssdk.services.pinpoint.model.PinpointException;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamRequest;
import software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesRequest;
import software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse;
import software.amazon.awssdk.services.pinpoint.model.TooManyRequestsException;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApnsSandboxChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateApplicationSettingsResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateCampaignResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEmailChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointsBatchResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateGcmChannelResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSegmentResponse;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateSmsChannelResponse;
import software.amazon.awssdk.services.pinpoint.transform.CreateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateCampaignResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateImportJobResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.CreateSegmentResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteApnsSandboxChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteCampaignResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEmailChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteEventStreamResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteGcmChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSegmentResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.DeleteSmsChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApnsSandboxChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetApplicationSettingsResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignActivitiesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignActivitiesResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetCampaignsResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEmailChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetEventStreamResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetGcmChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetImportJobsResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentImportJobsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentImportJobsResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentVersionsResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSegmentsResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.GetSmsChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventStreamRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.PutEventStreamResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendMessagesRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SendMessagesResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsSandboxChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApnsSandboxChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApplicationSettingsRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateApplicationSettingsResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateCampaignRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateCampaignResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEmailChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointsBatchRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateEndpointsBatchResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateGcmChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateGcmChannelResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSegmentRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSegmentResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsChannelRequestMarshaller;
import software.amazon.awssdk.services.pinpoint.transform.UpdateSmsChannelResponseUnmarshaller;

@SdkInternalApi
final class DefaultPinpointClient
implements PinpointClient {
    private final ClientHandler clientHandler;
    private final SdkJsonProtocolFactory protocolFactory;
    private final ClientConfiguration clientConfiguration;

    protected DefaultPinpointClient(SyncClientConfiguration clientConfiguration) {
        this.clientHandler = new SdkClientHandler(clientConfiguration, null);
        this.protocolFactory = this.init();
        this.clientConfiguration = clientConfiguration;
    }

    @Override
    public CreateCampaignResponse createCampaign(CreateCampaignRequest createCampaignRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateCampaignResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCampaignRequest).withMarshaller((Marshaller)new CreateCampaignRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateImportJobResponse createImportJob(CreateImportJobRequest createImportJobRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateImportJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createImportJobRequest).withMarshaller((Marshaller)new CreateImportJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateSegmentResponse createSegment(CreateSegmentRequest createSegmentRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateSegmentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (CreateSegmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createSegmentRequest).withMarshaller((Marshaller)new CreateSegmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteApnsChannelResponse deleteApnsChannel(DeleteApnsChannelRequest deleteApnsChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApnsChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteApnsChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApnsChannelRequest).withMarshaller((Marshaller)new DeleteApnsChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteApnsSandboxChannelResponse deleteApnsSandboxChannel(DeleteApnsSandboxChannelRequest deleteApnsSandboxChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteApnsSandboxChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteApnsSandboxChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApnsSandboxChannelRequest).withMarshaller((Marshaller)new DeleteApnsSandboxChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteCampaignResponse deleteCampaign(DeleteCampaignRequest deleteCampaignRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCampaignResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCampaignRequest).withMarshaller((Marshaller)new DeleteCampaignRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEmailChannelResponse deleteEmailChannel(DeleteEmailChannelRequest deleteEmailChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEmailChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteEmailChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEmailChannelRequest).withMarshaller((Marshaller)new DeleteEmailChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteEventStreamResponse deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEventStreamResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteEventStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteEventStreamRequest).withMarshaller((Marshaller)new DeleteEventStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteGcmChannelResponse deleteGcmChannel(DeleteGcmChannelRequest deleteGcmChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGcmChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteGcmChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGcmChannelRequest).withMarshaller((Marshaller)new DeleteGcmChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSegmentResponse deleteSegment(DeleteSegmentRequest deleteSegmentRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSegmentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteSegmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSegmentRequest).withMarshaller((Marshaller)new DeleteSegmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSmsChannelResponse deleteSmsChannel(DeleteSmsChannelRequest deleteSmsChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSmsChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (DeleteSmsChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSmsChannelRequest).withMarshaller((Marshaller)new DeleteSmsChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetApnsChannelResponse getApnsChannel(GetApnsChannelRequest getApnsChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetApnsChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetApnsChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getApnsChannelRequest).withMarshaller((Marshaller)new GetApnsChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetApnsSandboxChannelResponse getApnsSandboxChannel(GetApnsSandboxChannelRequest getApnsSandboxChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetApnsSandboxChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetApnsSandboxChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getApnsSandboxChannelRequest).withMarshaller((Marshaller)new GetApnsSandboxChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetApplicationSettingsResponse getApplicationSettings(GetApplicationSettingsRequest getApplicationSettingsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetApplicationSettingsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetApplicationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getApplicationSettingsRequest).withMarshaller((Marshaller)new GetApplicationSettingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCampaignResponse getCampaign(GetCampaignRequest getCampaignRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCampaignResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCampaignRequest).withMarshaller((Marshaller)new GetCampaignRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCampaignActivitiesResponse getCampaignActivities(GetCampaignActivitiesRequest getCampaignActivitiesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCampaignActivitiesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetCampaignActivitiesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCampaignActivitiesRequest).withMarshaller((Marshaller)new GetCampaignActivitiesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCampaignVersionResponse getCampaignVersion(GetCampaignVersionRequest getCampaignVersionRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCampaignVersionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetCampaignVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCampaignVersionRequest).withMarshaller((Marshaller)new GetCampaignVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCampaignVersionsResponse getCampaignVersions(GetCampaignVersionsRequest getCampaignVersionsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCampaignVersionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetCampaignVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCampaignVersionsRequest).withMarshaller((Marshaller)new GetCampaignVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetCampaignsResponse getCampaigns(GetCampaignsRequest getCampaignsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCampaignsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetCampaignsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCampaignsRequest).withMarshaller((Marshaller)new GetCampaignsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetEmailChannelResponse getEmailChannel(GetEmailChannelRequest getEmailChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEmailChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetEmailChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEmailChannelRequest).withMarshaller((Marshaller)new GetEmailChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetEndpointResponse getEndpoint(GetEndpointRequest getEndpointRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEndpointResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEndpointRequest).withMarshaller((Marshaller)new GetEndpointRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetEventStreamResponse getEventStream(GetEventStreamRequest getEventStreamRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetEventStreamResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetEventStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getEventStreamRequest).withMarshaller((Marshaller)new GetEventStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetGcmChannelResponse getGcmChannel(GetGcmChannelRequest getGcmChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetGcmChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetGcmChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGcmChannelRequest).withMarshaller((Marshaller)new GetGcmChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetImportJobResponse getImportJob(GetImportJobRequest getImportJobRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetImportJobResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getImportJobRequest).withMarshaller((Marshaller)new GetImportJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetImportJobsResponse getImportJobs(GetImportJobsRequest getImportJobsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetImportJobsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getImportJobsRequest).withMarshaller((Marshaller)new GetImportJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSegmentResponse getSegment(GetSegmentRequest getSegmentRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSegmentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetSegmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSegmentRequest).withMarshaller((Marshaller)new GetSegmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSegmentImportJobsResponse getSegmentImportJobs(GetSegmentImportJobsRequest getSegmentImportJobsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSegmentImportJobsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetSegmentImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSegmentImportJobsRequest).withMarshaller((Marshaller)new GetSegmentImportJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSegmentVersionResponse getSegmentVersion(GetSegmentVersionRequest getSegmentVersionRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSegmentVersionResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetSegmentVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSegmentVersionRequest).withMarshaller((Marshaller)new GetSegmentVersionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSegmentVersionsResponse getSegmentVersions(GetSegmentVersionsRequest getSegmentVersionsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSegmentVersionsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetSegmentVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSegmentVersionsRequest).withMarshaller((Marshaller)new GetSegmentVersionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSegmentsResponse getSegments(GetSegmentsRequest getSegmentsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSegmentsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetSegmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSegmentsRequest).withMarshaller((Marshaller)new GetSegmentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetSmsChannelResponse getSmsChannel(GetSmsChannelRequest getSmsChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetSmsChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (GetSmsChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSmsChannelRequest).withMarshaller((Marshaller)new GetSmsChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public PutEventStreamResponse putEventStream(PutEventStreamRequest putEventStreamRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutEventStreamResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (PutEventStreamResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putEventStreamRequest).withMarshaller((Marshaller)new PutEventStreamRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SendMessagesResponse sendMessages(SendMessagesRequest sendMessagesRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SendMessagesResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (SendMessagesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)sendMessagesRequest).withMarshaller((Marshaller)new SendMessagesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateApnsChannelResponse updateApnsChannel(UpdateApnsChannelRequest updateApnsChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateApnsChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateApnsChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApnsChannelRequest).withMarshaller((Marshaller)new UpdateApnsChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateApnsSandboxChannelResponse updateApnsSandboxChannel(UpdateApnsSandboxChannelRequest updateApnsSandboxChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateApnsSandboxChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateApnsSandboxChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApnsSandboxChannelRequest).withMarshaller((Marshaller)new UpdateApnsSandboxChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateApplicationSettingsResponse updateApplicationSettings(UpdateApplicationSettingsRequest updateApplicationSettingsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateApplicationSettingsResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateApplicationSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationSettingsRequest).withMarshaller((Marshaller)new UpdateApplicationSettingsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateCampaignResponse updateCampaign(UpdateCampaignRequest updateCampaignRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateCampaignResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateCampaignResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCampaignRequest).withMarshaller((Marshaller)new UpdateCampaignRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateEmailChannelResponse updateEmailChannel(UpdateEmailChannelRequest updateEmailChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEmailChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateEmailChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEmailChannelRequest).withMarshaller((Marshaller)new UpdateEmailChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest updateEndpointRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEndpointResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateEndpointResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEndpointRequest).withMarshaller((Marshaller)new UpdateEndpointRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateEndpointsBatchResponse updateEndpointsBatch(UpdateEndpointsBatchRequest updateEndpointsBatchRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateEndpointsBatchResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateEndpointsBatchResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateEndpointsBatchRequest).withMarshaller((Marshaller)new UpdateEndpointsBatchRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateGcmChannelResponse updateGcmChannel(UpdateGcmChannelRequest updateGcmChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGcmChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateGcmChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGcmChannelRequest).withMarshaller((Marshaller)new UpdateGcmChannelRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateSegmentResponse updateSegment(UpdateSegmentRequest updateSegmentRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSegmentResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateSegmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSegmentRequest).withMarshaller((Marshaller)new UpdateSegmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateSmsChannelResponse updateSmsChannel(UpdateSmsChannelRequest updateSmsChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, SdkBaseException, SdkClientException, PinpointException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateSmsChannelResponseUnmarshaller());
        HttpResponseHandler<AmazonServiceException> errorResponseHandler = this.createErrorResponseHandler();
        return (UpdateSmsChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSmsChannelRequest).withMarshaller((Marshaller)new UpdateSmsChannelRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AmazonServiceException> createErrorResponseHandler() {
        return this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private SdkJsonProtocolFactory init() {
        return new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withBaseServiceExceptionClass(PinpointException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MethodNotAllowedException").withModeledClass(MethodNotAllowedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)));
    }

    public void close() {
        this.clientHandler.close();
    }
}

