/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.EndpointBatchItem;
import software.amazon.awssdk.services.pinpoint.model.ListOfEndpointBatchItemCopier;
import software.amazon.awssdk.services.pinpoint.transform.EndpointBatchRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EndpointBatchRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, EndpointBatchRequest> {
    private final List<EndpointBatchItem> item;

    private EndpointBatchRequest(BuilderImpl builder) {
        this.item = builder.item;
    }

    public List<EndpointBatchItem> item() {
        return this.item;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.item() == null ? 0 : this.item().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointBatchRequest)) {
            return false;
        }
        EndpointBatchRequest other = (EndpointBatchRequest)obj;
        if (other.item() == null ^ this.item() == null) {
            return false;
        }
        return other.item() == null || other.item().equals(this.item());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.item() != null) {
            sb.append("Item: ").append(this.item()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EndpointBatchRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EndpointBatchItem> item;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointBatchRequest model) {
            this.setItem(model.item);
        }

        public final Collection<EndpointBatchItem> getItem() {
            return this.item;
        }

        @Override
        public final Builder item(Collection<EndpointBatchItem> item) {
            this.item = ListOfEndpointBatchItemCopier.copy(item);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder item(EndpointBatchItem ... item) {
            this.item(Arrays.asList(item));
            return this;
        }

        public final void setItem(Collection<EndpointBatchItem> item) {
            this.item = ListOfEndpointBatchItemCopier.copy(item);
        }

        public EndpointBatchRequest build() {
            return new EndpointBatchRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EndpointBatchRequest> {
        public Builder item(Collection<EndpointBatchItem> var1);

        public Builder item(EndpointBatchItem ... var1);
    }
}

