/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.DefaultMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DefaultMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, DefaultMessage> {
    private final String body;
    private final Map<String, List<String>> substitutions;

    private DefaultMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.substitutions = builder.substitutions;
    }

    public String body() {
        return this.body;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        hashCode = 31 * hashCode + (this.substitutions() == null ? 0 : this.substitutions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultMessage)) {
            return false;
        }
        DefaultMessage other = (DefaultMessage)obj;
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.substitutions() == null ^ this.substitutions() == null) {
            return false;
        }
        return other.substitutions() == null || other.substitutions().equals(this.substitutions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.substitutions() != null) {
            sb.append("Substitutions: ").append(this.substitutions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DefaultMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String body;
        private Map<String, List<String>> substitutions;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultMessage model) {
            this.setBody(model.body);
            this.setSubstitutions(model.substitutions);
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public DefaultMessage build() {
            return new DefaultMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefaultMessage> {
        public Builder body(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);
    }
}

