/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.GCMMessage;

public class GCMMessageUnmarshaller
implements Unmarshaller<GCMMessage, JsonUnmarshallerContext> {
    private static final GCMMessageUnmarshaller INSTANCE = new GCMMessageUnmarshaller();

    public GCMMessage unmarshall(JsonUnmarshallerContext context) throws Exception {
        GCMMessage.Builder gcmMessageBuilder = GCMMessage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.action((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.body((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("CollapseKey", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.collapseKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.data(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("IconReference", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.iconReference((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageIconUrl", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.imageIconUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ImageUrl", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.imageUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RawContent", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.rawContent((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RestrictedPackageName", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.restrictedPackageName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SilentPush", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.silentPush((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("SmallImageIconUrl", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.smallImageIconUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Sound", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.sound((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Substitutions", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.substitutions(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.title((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Url", targetDepth)) {
                    context.nextToken();
                    gcmMessageBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GCMMessage)gcmMessageBuilder.build();
    }

    public static GCMMessageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

