/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.APNSMessage;

public class APNSMessageUnmarshaller
implements Unmarshaller<APNSMessage, JsonUnmarshallerContext> {
    private static final APNSMessageUnmarshaller INSTANCE = new APNSMessageUnmarshaller();

    public APNSMessage unmarshall(JsonUnmarshallerContext context) throws Exception {
        APNSMessage.Builder apnsMessageBuilder = APNSMessage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.action((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Badge", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.badge((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.body((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Category", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.category((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Data", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.data(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("MediaUrl", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.mediaUrl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RawContent", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.rawContent((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SilentPush", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.silentPush((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("Sound", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.sound((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Substitutions", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.substitutions(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("ThreadId", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.threadId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Title", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.title((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Url", targetDepth)) {
                    context.nextToken();
                    apnsMessageBuilder.url((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (APNSMessage)apnsMessageBuilder.build();
    }

    public static APNSMessageUnmarshaller getInstance() {
        return INSTANCE;
    }
}

