/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.CampaignEmailMessage;
import software.amazon.awssdk.services.pinpoint.model.CampaignSmsMessage;
import software.amazon.awssdk.services.pinpoint.model.Message;
import software.amazon.awssdk.services.pinpoint.transform.MessageConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MessageConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, MessageConfiguration> {
    private final Message apnsMessage;
    private final Message defaultMessage;
    private final CampaignEmailMessage emailMessage;
    private final Message gcmMessage;
    private final CampaignSmsMessage smsMessage;

    private MessageConfiguration(BuilderImpl builder) {
        this.apnsMessage = builder.apnsMessage;
        this.defaultMessage = builder.defaultMessage;
        this.emailMessage = builder.emailMessage;
        this.gcmMessage = builder.gcmMessage;
        this.smsMessage = builder.smsMessage;
    }

    public Message apnsMessage() {
        return this.apnsMessage;
    }

    public Message defaultMessage() {
        return this.defaultMessage;
    }

    public CampaignEmailMessage emailMessage() {
        return this.emailMessage;
    }

    public Message gcmMessage() {
        return this.gcmMessage;
    }

    public CampaignSmsMessage smsMessage() {
        return this.smsMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.apnsMessage() == null ? 0 : this.apnsMessage().hashCode());
        hashCode = 31 * hashCode + (this.defaultMessage() == null ? 0 : this.defaultMessage().hashCode());
        hashCode = 31 * hashCode + (this.emailMessage() == null ? 0 : this.emailMessage().hashCode());
        hashCode = 31 * hashCode + (this.gcmMessage() == null ? 0 : this.gcmMessage().hashCode());
        hashCode = 31 * hashCode + (this.smsMessage() == null ? 0 : this.smsMessage().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageConfiguration)) {
            return false;
        }
        MessageConfiguration other = (MessageConfiguration)obj;
        if (other.apnsMessage() == null ^ this.apnsMessage() == null) {
            return false;
        }
        if (other.apnsMessage() != null && !other.apnsMessage().equals(this.apnsMessage())) {
            return false;
        }
        if (other.defaultMessage() == null ^ this.defaultMessage() == null) {
            return false;
        }
        if (other.defaultMessage() != null && !other.defaultMessage().equals(this.defaultMessage())) {
            return false;
        }
        if (other.emailMessage() == null ^ this.emailMessage() == null) {
            return false;
        }
        if (other.emailMessage() != null && !other.emailMessage().equals(this.emailMessage())) {
            return false;
        }
        if (other.gcmMessage() == null ^ this.gcmMessage() == null) {
            return false;
        }
        if (other.gcmMessage() != null && !other.gcmMessage().equals(this.gcmMessage())) {
            return false;
        }
        if (other.smsMessage() == null ^ this.smsMessage() == null) {
            return false;
        }
        return other.smsMessage() == null || other.smsMessage().equals(this.smsMessage());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apnsMessage() != null) {
            sb.append("APNSMessage: ").append(this.apnsMessage()).append(",");
        }
        if (this.defaultMessage() != null) {
            sb.append("DefaultMessage: ").append(this.defaultMessage()).append(",");
        }
        if (this.emailMessage() != null) {
            sb.append("EmailMessage: ").append(this.emailMessage()).append(",");
        }
        if (this.gcmMessage() != null) {
            sb.append("GCMMessage: ").append(this.gcmMessage()).append(",");
        }
        if (this.smsMessage() != null) {
            sb.append("SMSMessage: ").append(this.smsMessage()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MessageConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Message apnsMessage;
        private Message defaultMessage;
        private CampaignEmailMessage emailMessage;
        private Message gcmMessage;
        private CampaignSmsMessage smsMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageConfiguration model) {
            this.setAPNSMessage(model.apnsMessage);
            this.setDefaultMessage(model.defaultMessage);
            this.setEmailMessage(model.emailMessage);
            this.setGCMMessage(model.gcmMessage);
            this.setSMSMessage(model.smsMessage);
        }

        public final Message getAPNSMessage() {
            return this.apnsMessage;
        }

        @Override
        public final Builder apnsMessage(Message apnsMessage) {
            this.apnsMessage = apnsMessage;
            return this;
        }

        public final void setAPNSMessage(Message apnsMessage) {
            this.apnsMessage = apnsMessage;
        }

        public final Message getDefaultMessage() {
            return this.defaultMessage;
        }

        @Override
        public final Builder defaultMessage(Message defaultMessage) {
            this.defaultMessage = defaultMessage;
            return this;
        }

        public final void setDefaultMessage(Message defaultMessage) {
            this.defaultMessage = defaultMessage;
        }

        public final CampaignEmailMessage getEmailMessage() {
            return this.emailMessage;
        }

        @Override
        public final Builder emailMessage(CampaignEmailMessage emailMessage) {
            this.emailMessage = emailMessage;
            return this;
        }

        public final void setEmailMessage(CampaignEmailMessage emailMessage) {
            this.emailMessage = emailMessage;
        }

        public final Message getGCMMessage() {
            return this.gcmMessage;
        }

        @Override
        public final Builder gcmMessage(Message gcmMessage) {
            this.gcmMessage = gcmMessage;
            return this;
        }

        public final void setGCMMessage(Message gcmMessage) {
            this.gcmMessage = gcmMessage;
        }

        public final CampaignSmsMessage getSMSMessage() {
            return this.smsMessage;
        }

        @Override
        public final Builder smsMessage(CampaignSmsMessage smsMessage) {
            this.smsMessage = smsMessage;
            return this;
        }

        public final void setSMSMessage(CampaignSmsMessage smsMessage) {
            this.smsMessage = smsMessage;
        }

        public MessageConfiguration build() {
            return new MessageConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MessageConfiguration> {
        public Builder apnsMessage(Message var1);

        public Builder defaultMessage(Message var1);

        public Builder emailMessage(CampaignEmailMessage var1);

        public Builder gcmMessage(Message var1);

        public Builder smsMessage(CampaignSmsMessage var1);
    }
}

