/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Action;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.transform.APNSMessageMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class APNSMessage
implements StructuredPojo,
ToCopyableBuilder<Builder, APNSMessage> {
    private final String action;
    private final Integer badge;
    private final String body;
    private final String category;
    private final Map<String, String> data;
    private final String mediaUrl;
    private final String rawContent;
    private final Boolean silentPush;
    private final String sound;
    private final Map<String, List<String>> substitutions;
    private final String threadId;
    private final String title;
    private final String url;

    private APNSMessage(BuilderImpl builder) {
        this.action = builder.action;
        this.badge = builder.badge;
        this.body = builder.body;
        this.category = builder.category;
        this.data = builder.data;
        this.mediaUrl = builder.mediaUrl;
        this.rawContent = builder.rawContent;
        this.silentPush = builder.silentPush;
        this.sound = builder.sound;
        this.substitutions = builder.substitutions;
        this.threadId = builder.threadId;
        this.title = builder.title;
        this.url = builder.url;
    }

    public String action() {
        return this.action;
    }

    public Integer badge() {
        return this.badge;
    }

    public String body() {
        return this.body;
    }

    public String category() {
        return this.category;
    }

    public Map<String, String> data() {
        return this.data;
    }

    public String mediaUrl() {
        return this.mediaUrl;
    }

    public String rawContent() {
        return this.rawContent;
    }

    public Boolean silentPush() {
        return this.silentPush;
    }

    public String sound() {
        return this.sound;
    }

    public Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public String threadId() {
        return this.threadId;
    }

    public String title() {
        return this.title;
    }

    public String url() {
        return this.url;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.action() == null ? 0 : this.action().hashCode());
        hashCode = 31 * hashCode + (this.badge() == null ? 0 : this.badge().hashCode());
        hashCode = 31 * hashCode + (this.body() == null ? 0 : this.body().hashCode());
        hashCode = 31 * hashCode + (this.category() == null ? 0 : this.category().hashCode());
        hashCode = 31 * hashCode + (this.data() == null ? 0 : this.data().hashCode());
        hashCode = 31 * hashCode + (this.mediaUrl() == null ? 0 : this.mediaUrl().hashCode());
        hashCode = 31 * hashCode + (this.rawContent() == null ? 0 : this.rawContent().hashCode());
        hashCode = 31 * hashCode + (this.silentPush() == null ? 0 : this.silentPush().hashCode());
        hashCode = 31 * hashCode + (this.sound() == null ? 0 : this.sound().hashCode());
        hashCode = 31 * hashCode + (this.substitutions() == null ? 0 : this.substitutions().hashCode());
        hashCode = 31 * hashCode + (this.threadId() == null ? 0 : this.threadId().hashCode());
        hashCode = 31 * hashCode + (this.title() == null ? 0 : this.title().hashCode());
        hashCode = 31 * hashCode + (this.url() == null ? 0 : this.url().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof APNSMessage)) {
            return false;
        }
        APNSMessage other = (APNSMessage)obj;
        if (other.action() == null ^ this.action() == null) {
            return false;
        }
        if (other.action() != null && !other.action().equals(this.action())) {
            return false;
        }
        if (other.badge() == null ^ this.badge() == null) {
            return false;
        }
        if (other.badge() != null && !other.badge().equals(this.badge())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        if (other.category() == null ^ this.category() == null) {
            return false;
        }
        if (other.category() != null && !other.category().equals(this.category())) {
            return false;
        }
        if (other.data() == null ^ this.data() == null) {
            return false;
        }
        if (other.data() != null && !other.data().equals(this.data())) {
            return false;
        }
        if (other.mediaUrl() == null ^ this.mediaUrl() == null) {
            return false;
        }
        if (other.mediaUrl() != null && !other.mediaUrl().equals(this.mediaUrl())) {
            return false;
        }
        if (other.rawContent() == null ^ this.rawContent() == null) {
            return false;
        }
        if (other.rawContent() != null && !other.rawContent().equals(this.rawContent())) {
            return false;
        }
        if (other.silentPush() == null ^ this.silentPush() == null) {
            return false;
        }
        if (other.silentPush() != null && !other.silentPush().equals(this.silentPush())) {
            return false;
        }
        if (other.sound() == null ^ this.sound() == null) {
            return false;
        }
        if (other.sound() != null && !other.sound().equals(this.sound())) {
            return false;
        }
        if (other.substitutions() == null ^ this.substitutions() == null) {
            return false;
        }
        if (other.substitutions() != null && !other.substitutions().equals(this.substitutions())) {
            return false;
        }
        if (other.threadId() == null ^ this.threadId() == null) {
            return false;
        }
        if (other.threadId() != null && !other.threadId().equals(this.threadId())) {
            return false;
        }
        if (other.title() == null ^ this.title() == null) {
            return false;
        }
        if (other.title() != null && !other.title().equals(this.title())) {
            return false;
        }
        if (other.url() == null ^ this.url() == null) {
            return false;
        }
        return other.url() == null || other.url().equals(this.url());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action() != null) {
            sb.append("Action: ").append(this.action()).append(",");
        }
        if (this.badge() != null) {
            sb.append("Badge: ").append(this.badge()).append(",");
        }
        if (this.body() != null) {
            sb.append("Body: ").append(this.body()).append(",");
        }
        if (this.category() != null) {
            sb.append("Category: ").append(this.category()).append(",");
        }
        if (this.data() != null) {
            sb.append("Data: ").append(this.data()).append(",");
        }
        if (this.mediaUrl() != null) {
            sb.append("MediaUrl: ").append(this.mediaUrl()).append(",");
        }
        if (this.rawContent() != null) {
            sb.append("RawContent: ").append(this.rawContent()).append(",");
        }
        if (this.silentPush() != null) {
            sb.append("SilentPush: ").append(this.silentPush()).append(",");
        }
        if (this.sound() != null) {
            sb.append("Sound: ").append(this.sound()).append(",");
        }
        if (this.substitutions() != null) {
            sb.append("Substitutions: ").append(this.substitutions()).append(",");
        }
        if (this.threadId() != null) {
            sb.append("ThreadId: ").append(this.threadId()).append(",");
        }
        if (this.title() != null) {
            sb.append("Title: ").append(this.title()).append(",");
        }
        if (this.url() != null) {
            sb.append("Url: ").append(this.url()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        APNSMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String action;
        private Integer badge;
        private String body;
        private String category;
        private Map<String, String> data;
        private String mediaUrl;
        private String rawContent;
        private Boolean silentPush;
        private String sound;
        private Map<String, List<String>> substitutions;
        private String threadId;
        private String title;
        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(APNSMessage model) {
            this.setAction(model.action);
            this.setBadge(model.badge);
            this.setBody(model.body);
            this.setCategory(model.category);
            this.setData(model.data);
            this.setMediaUrl(model.mediaUrl);
            this.setRawContent(model.rawContent);
            this.setSilentPush(model.silentPush);
            this.setSound(model.sound);
            this.setSubstitutions(model.substitutions);
            this.setThreadId(model.threadId);
            this.setTitle(model.title);
            this.setUrl(model.url);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getBadge() {
            return this.badge;
        }

        @Override
        public final Builder badge(Integer badge) {
            this.badge = badge;
            return this;
        }

        public final void setBadge(Integer badge) {
            this.badge = badge;
        }

        public final String getBody() {
            return this.body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final Map<String, String> getData() {
            return this.data;
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
            return this;
        }

        public final void setData(Map<String, String> data) {
            this.data = MapOf__stringCopier.copy(data);
        }

        public final String getMediaUrl() {
            return this.mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        public final String getRawContent() {
            return this.rawContent;
        }

        @Override
        public final Builder rawContent(String rawContent) {
            this.rawContent = rawContent;
            return this;
        }

        public final void setRawContent(String rawContent) {
            this.rawContent = rawContent;
        }

        public final Boolean getSilentPush() {
            return this.silentPush;
        }

        @Override
        public final Builder silentPush(Boolean silentPush) {
            this.silentPush = silentPush;
            return this;
        }

        public final void setSilentPush(Boolean silentPush) {
            this.silentPush = silentPush;
        }

        public final String getSound() {
            return this.sound;
        }

        @Override
        public final Builder sound(String sound) {
            this.sound = sound;
            return this;
        }

        public final void setSound(String sound) {
            this.sound = sound;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            return this.substitutions;
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        public final String getThreadId() {
            return this.threadId;
        }

        @Override
        public final Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        public final void setThreadId(String threadId) {
            this.threadId = threadId;
        }

        public final String getTitle() {
            return this.title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public APNSMessage build() {
            return new APNSMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, APNSMessage> {
        public Builder action(String var1);

        public Builder action(Action var1);

        public Builder badge(Integer var1);

        public Builder body(String var1);

        public Builder category(String var1);

        public Builder data(Map<String, String> var1);

        public Builder mediaUrl(String var1);

        public Builder rawContent(String var1);

        public Builder silentPush(Boolean var1);

        public Builder sound(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder threadId(String var1);

        public Builder title(String var1);

        public Builder url(String var1);
    }
}

