/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.SMSMessage;

public class SMSMessageUnmarshaller
implements Unmarshaller<SMSMessage, JsonUnmarshallerContext> {
    private static SMSMessageUnmarshaller INSTANCE;

    public SMSMessage unmarshall(JsonUnmarshallerContext context) throws Exception {
        SMSMessage.Builder smsMessageBuilder = SMSMessage.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Body", targetDepth)) {
                    context.nextToken();
                    smsMessageBuilder.body((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("MessageType", targetDepth)) {
                    context.nextToken();
                    smsMessageBuilder.messageType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SenderId", targetDepth)) {
                    context.nextToken();
                    smsMessageBuilder.senderId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Substitutions", targetDepth)) {
                    context.nextToken();
                    smsMessageBuilder.substitutions(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SMSMessage)smsMessageBuilder.build();
    }

    public static SMSMessageUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SMSMessageUnmarshaller();
        }
        return INSTANCE;
    }
}

