/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.GCMChannelRequest;

@SdkInternalApi
public class GCMChannelRequestMarshaller {
    private static final MarshallingInfo<String> APIKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApiKey").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final GCMChannelRequestMarshaller instance = new GCMChannelRequestMarshaller();

    public static GCMChannelRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(GCMChannelRequest gcmChannelRequest, ProtocolMarshaller protocolMarshaller) {
        if (gcmChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)gcmChannelRequest.apiKey(), APIKEY_BINDING);
            protocolMarshaller.marshall((Object)gcmChannelRequest.enabled(), ENABLED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

