/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.Format;
import software.amazon.awssdk.services.pinpoint.transform.ImportJobRequestMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImportJobRequest
implements StructuredPojo,
ToCopyableBuilder<Builder, ImportJobRequest> {
    private final Boolean defineSegment;
    private final String externalId;
    private final String format;
    private final Boolean registerEndpoints;
    private final String roleArn;
    private final String s3Url;
    private final String segmentId;
    private final String segmentName;

    private ImportJobRequest(BuilderImpl builder) {
        this.defineSegment = builder.defineSegment;
        this.externalId = builder.externalId;
        this.format = builder.format;
        this.registerEndpoints = builder.registerEndpoints;
        this.roleArn = builder.roleArn;
        this.s3Url = builder.s3Url;
        this.segmentId = builder.segmentId;
        this.segmentName = builder.segmentName;
    }

    public Boolean defineSegment() {
        return this.defineSegment;
    }

    public String externalId() {
        return this.externalId;
    }

    public String format() {
        return this.format;
    }

    public Boolean registerEndpoints() {
        return this.registerEndpoints;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String s3Url() {
        return this.s3Url;
    }

    public String segmentId() {
        return this.segmentId;
    }

    public String segmentName() {
        return this.segmentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.defineSegment() == null ? 0 : this.defineSegment().hashCode());
        hashCode = 31 * hashCode + (this.externalId() == null ? 0 : this.externalId().hashCode());
        hashCode = 31 * hashCode + (this.format() == null ? 0 : this.format().hashCode());
        hashCode = 31 * hashCode + (this.registerEndpoints() == null ? 0 : this.registerEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.roleArn() == null ? 0 : this.roleArn().hashCode());
        hashCode = 31 * hashCode + (this.s3Url() == null ? 0 : this.s3Url().hashCode());
        hashCode = 31 * hashCode + (this.segmentId() == null ? 0 : this.segmentId().hashCode());
        hashCode = 31 * hashCode + (this.segmentName() == null ? 0 : this.segmentName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportJobRequest)) {
            return false;
        }
        ImportJobRequest other = (ImportJobRequest)obj;
        if (other.defineSegment() == null ^ this.defineSegment() == null) {
            return false;
        }
        if (other.defineSegment() != null && !other.defineSegment().equals(this.defineSegment())) {
            return false;
        }
        if (other.externalId() == null ^ this.externalId() == null) {
            return false;
        }
        if (other.externalId() != null && !other.externalId().equals(this.externalId())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.registerEndpoints() == null ^ this.registerEndpoints() == null) {
            return false;
        }
        if (other.registerEndpoints() != null && !other.registerEndpoints().equals(this.registerEndpoints())) {
            return false;
        }
        if (other.roleArn() == null ^ this.roleArn() == null) {
            return false;
        }
        if (other.roleArn() != null && !other.roleArn().equals(this.roleArn())) {
            return false;
        }
        if (other.s3Url() == null ^ this.s3Url() == null) {
            return false;
        }
        if (other.s3Url() != null && !other.s3Url().equals(this.s3Url())) {
            return false;
        }
        if (other.segmentId() == null ^ this.segmentId() == null) {
            return false;
        }
        if (other.segmentId() != null && !other.segmentId().equals(this.segmentId())) {
            return false;
        }
        if (other.segmentName() == null ^ this.segmentName() == null) {
            return false;
        }
        return other.segmentName() == null || other.segmentName().equals(this.segmentName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defineSegment() != null) {
            sb.append("DefineSegment: ").append(this.defineSegment()).append(",");
        }
        if (this.externalId() != null) {
            sb.append("ExternalId: ").append(this.externalId()).append(",");
        }
        if (this.format() != null) {
            sb.append("Format: ").append(this.format()).append(",");
        }
        if (this.registerEndpoints() != null) {
            sb.append("RegisterEndpoints: ").append(this.registerEndpoints()).append(",");
        }
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.s3Url() != null) {
            sb.append("S3Url: ").append(this.s3Url()).append(",");
        }
        if (this.segmentId() != null) {
            sb.append("SegmentId: ").append(this.segmentId()).append(",");
        }
        if (this.segmentName() != null) {
            sb.append("SegmentName: ").append(this.segmentName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImportJobRequestMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean defineSegment;
        private String externalId;
        private String format;
        private Boolean registerEndpoints;
        private String roleArn;
        private String s3Url;
        private String segmentId;
        private String segmentName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportJobRequest model) {
            this.setDefineSegment(model.defineSegment);
            this.setExternalId(model.externalId);
            this.setFormat(model.format);
            this.setRegisterEndpoints(model.registerEndpoints);
            this.setRoleArn(model.roleArn);
            this.setS3Url(model.s3Url);
            this.setSegmentId(model.segmentId);
            this.setSegmentName(model.segmentName);
        }

        public final Boolean getDefineSegment() {
            return this.defineSegment;
        }

        @Override
        public final Builder defineSegment(Boolean defineSegment) {
            this.defineSegment = defineSegment;
            return this;
        }

        public final void setDefineSegment(Boolean defineSegment) {
            this.defineSegment = defineSegment;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final void setFormat(Format format) {
            this.format(format.toString());
        }

        public final Boolean getRegisterEndpoints() {
            return this.registerEndpoints;
        }

        @Override
        public final Builder registerEndpoints(Boolean registerEndpoints) {
            this.registerEndpoints = registerEndpoints;
            return this;
        }

        public final void setRegisterEndpoints(Boolean registerEndpoints) {
            this.registerEndpoints = registerEndpoints;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getS3Url() {
            return this.s3Url;
        }

        @Override
        public final Builder s3Url(String s3Url) {
            this.s3Url = s3Url;
            return this;
        }

        public final void setS3Url(String s3Url) {
            this.s3Url = s3Url;
        }

        public final String getSegmentId() {
            return this.segmentId;
        }

        @Override
        public final Builder segmentId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public final void setSegmentId(String segmentId) {
            this.segmentId = segmentId;
        }

        public final String getSegmentName() {
            return this.segmentName;
        }

        @Override
        public final Builder segmentName(String segmentName) {
            this.segmentName = segmentName;
            return this;
        }

        public final void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        public ImportJobRequest build() {
            return new ImportJobRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImportJobRequest> {
        public Builder defineSegment(Boolean var1);

        public Builder externalId(String var1);

        public Builder format(String var1);

        public Builder format(Format var1);

        public Builder registerEndpoints(Boolean var1);

        public Builder roleArn(String var1);

        public Builder s3Url(String var1);

        public Builder segmentId(String var1);

        public Builder segmentName(String var1);
    }
}

