/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateEndpointRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("application-id").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("endpoint-id").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINTREQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(false).build();
    private static final UpdateEndpointRequestModelMarshaller INSTANCE = new UpdateEndpointRequestModelMarshaller();

    private UpdateEndpointRequestModelMarshaller() {
    }

    public static UpdateEndpointRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateEndpointRequest updateEndpointRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateEndpointRequest), (String)"updateEndpointRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateEndpointRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)updateEndpointRequest.endpointId(), ENDPOINTID_BINDING);
            protocolMarshaller.marshall((Object)updateEndpointRequest.endpointRequest(), ENDPOINTREQUEST_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

