/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.Session;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SessionMarshaller {
    private static final MarshallingInfo<Integer> DURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Duration").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> STARTTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTimestamp").isBinary(false).build();
    private static final MarshallingInfo<String> STOPTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StopTimestamp").isBinary(false).build();
    private static final SessionMarshaller INSTANCE = new SessionMarshaller();

    private SessionMarshaller() {
    }

    public static SessionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Session session, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)session, (String)"session");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)session.duration(), DURATION_BINDING);
            protocolMarshaller.marshall((Object)session.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)session.startTimestamp(), STARTTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)session.stopTimestamp(), STOPTIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

