/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.SegmentLocation;
import software.amazon.awssdk.services.pinpoint.transform.GPSPointDimensionUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.SetDimensionUnmarshaller;

public class SegmentLocationUnmarshaller
implements Unmarshaller<SegmentLocation, JsonUnmarshallerContext> {
    private static final SegmentLocationUnmarshaller INSTANCE = new SegmentLocationUnmarshaller();

    public SegmentLocation unmarshall(JsonUnmarshallerContext context) throws Exception {
        SegmentLocation.Builder segmentLocationBuilder = SegmentLocation.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Country", targetDepth)) {
                    context.nextToken();
                    segmentLocationBuilder.country(SetDimensionUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("GPSPoint", targetDepth)) {
                    context.nextToken();
                    segmentLocationBuilder.gpsPoint(GPSPointDimensionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (SegmentLocation)segmentLocationBuilder.build();
    }

    public static SegmentLocationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

