/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.PublicEndpoint;
import software.amazon.awssdk.services.pinpoint.transform.EndpointDemographicUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.EndpointLocationUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.EndpointUserUnmarshaller;

public class PublicEndpointUnmarshaller
implements Unmarshaller<PublicEndpoint, JsonUnmarshallerContext> {
    private static final PublicEndpointUnmarshaller INSTANCE = new PublicEndpointUnmarshaller();

    public PublicEndpoint unmarshall(JsonUnmarshallerContext context) throws Exception {
        PublicEndpoint.Builder publicEndpointBuilder = PublicEndpoint.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Address", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.address((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Attributes", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.attributes(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)new ListUnmarshaller(context.getUnmarshaller(String.class))).unmarshall(context));
                }
                if (context.testExpression("ChannelType", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.channelType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Demographic", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.demographic(EndpointDemographicUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EffectiveDate", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.effectiveDate((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("EndpointStatus", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.endpointStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Location", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.location(EndpointLocationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("Metrics", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.metrics(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(Double.class)).unmarshall(context));
                }
                if (context.testExpression("OptOut", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.optOut((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("RequestId", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.requestId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("User", targetDepth)) {
                    context.nextToken();
                    publicEndpointBuilder.user(EndpointUserUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PublicEndpoint)publicEndpointBuilder.build();
    }

    public static PublicEndpointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

