/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.MetricDimension;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MetricDimensionMarshaller {
    private static final MarshallingInfo<String> COMPARISONOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ComparisonOperator").isBinary(false).build();
    private static final MarshallingInfo<Double> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").isBinary(false).build();
    private static final MetricDimensionMarshaller INSTANCE = new MetricDimensionMarshaller();

    private MetricDimensionMarshaller() {
    }

    public static MetricDimensionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MetricDimension metricDimension, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)metricDimension, (String)"metricDimension");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)metricDimension.comparisonOperator(), COMPARISONOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)metricDimension.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

