/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.MessageResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MessageResultMarshaller {
    private static final MarshallingInfo<String> DELIVERYSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeliveryStatus").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageId").isBinary(false).build();
    private static final MarshallingInfo<Integer> STATUSCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusCode").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").isBinary(false).build();
    private static final MarshallingInfo<String> UPDATEDTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedToken").isBinary(false).build();
    private static final MessageResultMarshaller INSTANCE = new MessageResultMarshaller();

    private MessageResultMarshaller() {
    }

    public static MessageResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MessageResult messageResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)messageResult, (String)"messageResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)messageResult.deliveryStatusAsString(), DELIVERYSTATUS_BINDING);
            protocolMarshaller.marshall((Object)messageResult.messageId(), MESSAGEID_BINDING);
            protocolMarshaller.marshall((Object)messageResult.statusCode(), STATUSCODE_BINDING);
            protocolMarshaller.marshall((Object)messageResult.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)messageResult.updatedToken(), UPDATEDTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

