/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.ItemResponse;
import software.amazon.awssdk.services.pinpoint.transform.EndpointItemResponseUnmarshaller;
import software.amazon.awssdk.services.pinpoint.transform.EventItemResponseUnmarshaller;

public class ItemResponseUnmarshaller
implements Unmarshaller<ItemResponse, JsonUnmarshallerContext> {
    private static final ItemResponseUnmarshaller INSTANCE = new ItemResponseUnmarshaller();

    public ItemResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        ItemResponse.Builder itemResponseBuilder = ItemResponse.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("EndpointItemResponse", targetDepth)) {
                    context.nextToken();
                    itemResponseBuilder.endpointItemResponse(EndpointItemResponseUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("EventsItemResponse", targetDepth)) {
                    context.nextToken();
                    itemResponseBuilder.eventsItemResponse(new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)EventItemResponseUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ItemResponse)itemResponseBuilder.build();
    }

    public static ItemResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

