/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.GetSegmentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetSegmentRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("application-id").isBinary(false).build();
    private static final MarshallingInfo<String> SEGMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("segment-id").isBinary(false).build();
    private static final GetSegmentRequestModelMarshaller INSTANCE = new GetSegmentRequestModelMarshaller();

    private GetSegmentRequestModelMarshaller() {
    }

    public static GetSegmentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetSegmentRequest getSegmentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getSegmentRequest), (String)"getSegmentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getSegmentRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)getSegmentRequest.segmentId(), SEGMENTID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

