/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.GPSPointDimension;
import software.amazon.awssdk.services.pinpoint.transform.GPSCoordinatesUnmarshaller;

public class GPSPointDimensionUnmarshaller
implements Unmarshaller<GPSPointDimension, JsonUnmarshallerContext> {
    private static final GPSPointDimensionUnmarshaller INSTANCE = new GPSPointDimensionUnmarshaller();

    public GPSPointDimension unmarshall(JsonUnmarshallerContext context) throws Exception {
        GPSPointDimension.Builder gpsPointDimensionBuilder = GPSPointDimension.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Coordinates", targetDepth)) {
                    context.nextToken();
                    gpsPointDimensionBuilder.coordinates(GPSCoordinatesUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RangeInKilometers", targetDepth)) {
                    context.nextToken();
                    gpsPointDimensionBuilder.rangeInKilometers((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GPSPointDimension)gpsPointDimensionBuilder.build();
    }

    public static GPSPointDimensionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

