/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.pinpoint.model.GPSCoordinates;

public class GPSCoordinatesUnmarshaller
implements Unmarshaller<GPSCoordinates, JsonUnmarshallerContext> {
    private static final GPSCoordinatesUnmarshaller INSTANCE = new GPSCoordinatesUnmarshaller();

    public GPSCoordinates unmarshall(JsonUnmarshallerContext context) throws Exception {
        GPSCoordinates.Builder gpsCoordinatesBuilder = GPSCoordinates.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Latitude", targetDepth)) {
                    context.nextToken();
                    gpsCoordinatesBuilder.latitude((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("Longitude", targetDepth)) {
                    context.nextToken();
                    gpsCoordinatesBuilder.longitude((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (GPSCoordinates)gpsCoordinatesBuilder.build();
    }

    public static GPSCoordinatesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

