/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.pinpoint.model.EventsResponse;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EventsResponseMarshaller {
    private static final MarshallingInfo<Map> RESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Results").isBinary(false).build();
    private static final EventsResponseMarshaller INSTANCE = new EventsResponseMarshaller();

    private EventsResponseMarshaller() {
    }

    public static EventsResponseMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EventsResponse eventsResponse, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)eventsResponse, (String)"eventsResponse");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(eventsResponse.results(), RESULTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

